/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchSelectorPref {
    private final JSONObject json;

    public BranchSelectorPref(JSONObject json) {
        this.json = json == null ? new JSONObject() : json;
    }

    public Set<String> getRepositories() throws JSONException {
        HashSet<String> keys = new HashSet<String>();
        Iterator it = this.json.keys();
        while (it.hasNext()) {
            keys.add(it.next().toString());
        }
        return keys;
    }

    public Branch getSelectedBranchForRepository(String repName) throws JSONException {
        if (!this.json.has(repName)) {
            return null;
        }
        Object branchObject = this.json.get(repName);
        if (!(branchObject instanceof JSONObject)) {
            throw new JSONException("Value for repository " + repName + " was not a JSONObject");
        }
        return new Branch((JSONObject)branchObject);
    }

    public JSONObject getSelectedBranchObjectForRepository(String repName) throws JSONException {
        if (!this.json.has(repName)) {
            return null;
        }
        Object branchObject = this.json.get(repName);
        if (!(branchObject instanceof JSONObject)) {
            throw new JSONException("Value for repository " + repName + " was not a JSONObject");
        }
        return (JSONObject)branchObject;
    }

    public static class Branch {
        public final String type;
        public final String name;

        public Branch(JSONObject json) throws JSONException {
            this.type = (String)json.get("t");
            this.name = (String)json.get("n");
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Branch branch = (Branch)o2;
            if (this.name != null ? !this.name.equals(branch.name) : branch.name != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(branch.type) : branch.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

