/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.branch.BranchPreferenceHandler;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.parameterbeans.ViewFileActionParams;
import com.cenqua.fisheye.web.parameterbeans.WatchParams;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseAction {
    public static final int MOD_ALWAYS_SEND = -1;
    private FishEyePathInfo pathInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private RevisionCache repositoryCache;
    private String repName;
    protected WaybackSpec waybackSpec;
    protected ActivityItemSearchParams activityStreamParams;
    private UserProfile userProfile;
    @Resource
    protected CommitterUserMappingManager committerUserMappingManager;
    @Resource
    protected UserManager userManager;
    @Resource
    protected UserProfileManager userProfileManager;
    @Resource
    private BranchPreferenceHandler branchPreferenceHandler;
    @Resource
    private RepositoryManager repositoryManager;

    public String getBranchConstraint(Path physicalPath) {
        String br;
        String string = br = this.activityStreamParams == null ? null : this.activityStreamParams.getBranch();
        if (br == null) {
            br = this.repositoryCache.getImpliedBranch(physicalPath);
        }
        return br;
    }

    public FishEyePathInfo getPathInfo() {
        return this.pathInfo;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean requiresAuth() {
        return !AppConfig.getsConfig().getConfig().getSecurity().getAllowAnon() || !this.getPathInfo().getRepository().isAnonAccessAllowed();
    }

    protected void setupInternal(FishEyePathInfo pi, HttpServletRequest req, HttpServletResponse res, ServletContext sctx, BaseActionParams params) {
        this.pathInfo = pi;
        this.request = req;
        this.response = res;
        this.servletContext = sctx;
        this.repositoryCache = pi.getEngine().getRevisionCache();
        this.repName = pi.getEngine().getName();
    }

    public void setup() {
    }

    public RevisionCache<? extends ChangeSet> getRepositoryCache() {
        return this.repositoryCache;
    }

    protected CookiePreferences getUserPreferences() {
        return PreferenceManager.getPreferences(this.getRequest());
    }

    protected UserProfile getUserProfile() {
        if (this.userProfile == null) {
            UserLogin user = this.userManager.getCurrentUser(this.getRequest());
            try {
                if (user == null) {
                    return UserProfileManager.DEFAULT_PROFILE;
                }
                this.userProfile = this.userProfileManager.getProfile(user.getUserName());
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("DbException: " + e2.getMessage()), (Throwable)e2);
                return UserProfileManager.DEFAULT_PROFILE;
            }
        }
        return this.userProfile;
    }

    protected BranchPreferenceHandler getBranchPreferenceHandler() {
        return this.branchPreferenceHandler;
    }

    protected boolean handleWaybackJump(String mmodeUrl, CookiePreferences preferences) throws IOException {
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        this.getBranchPreferenceHandler().handleLastSelectedBranch(preferences, req, pi.getRepname());
        if (req.getParameter("wbjump") != null) {
            WaybackSpec wbSpec = WaybackSpec.fromRequest(req, this.waybackSpec);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(req.getContextPath()).append(mmodeUrl).append(wbSpec.getUrlCommand()).append("/").append(pi.getFullPath().getAsUrl());
            String queryString = req.getQueryString();
            if (!Strings.isNullOrEmpty((String)queryString)) {
                queryString = wbSpec.removeWbFromQueryString(queryString);
            }
            if (!Strings.isNullOrEmpty((String)req.getParameter("hb"))) {
                queryString = !Strings.isNullOrEmpty((String)(queryString = WaybackSpec.removeParamFromQueryString("hb", queryString))) ? queryString + "&" : "";
                queryString = queryString + "hb" + "=" + req.getParameter("hb");
            }
            if (!Strings.isNullOrEmpty((String)req.getParameter("brjump"))) {
                queryString = !Strings.isNullOrEmpty((String)(queryString = WaybackSpec.removeParamFromQueryString("brjump", queryString))) ? queryString + "&" : "";
                queryString = queryString + "brjump=" + req.getParameter("brjump");
            }
            if (!Strings.isNullOrEmpty((String)queryString)) {
                urlBuilder.append("?").append(queryString);
            }
            this.getResponse().sendRedirect(urlBuilder.toString());
            return true;
        }
        return false;
    }

    protected boolean handleSvnConflictingBranches(String mmodeUrl, RepositoryEngine engine) throws DbException, IOException {
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("brjump") != null) {
            FishEyePathInfo pi = this.getPathInfo();
            String queryString = req.getQueryString();
            queryString = WaybackSpec.removeParamFromQueryString("brjump", queryString);
            String pathUrl = RepositoryUtil.getPhysicalPathUrl(pi.getLocalPath(), this.waybackSpec, engine, pi.getRepname(), queryString);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(req.getContextPath()).append(mmodeUrl).append(pathUrl);
            this.getResponse().sendRedirect(urlBuilder.toString());
            return true;
        }
        return false;
    }

    protected void parseWaybackSpec() {
        WaybackSpec wbSpec = WaybackSpec.fromPathInfo(this.getPathInfo());
        if (wbSpec != null) {
            this.waybackSpec = wbSpec;
        }
    }

    protected void parseActivityItemSearchParams(TimeZone tz, String repname) {
        ActivityItemSearchParams.Builder param = ActivityItemSearchParams.builder().includeFisheye().includeCrucible().includeExternals().repository(repname).maxItems(30).timeZone(tz);
        this.activityStreamParams = ActivityStreamHandler.fromCommandString(param, this.getPathInfo());
    }

    public long computeLastModified() {
        return -1L;
    }

    protected long computeRepositoryLastModified() {
        return this.repositoryManager.getLastModified(this.pathInfo.getRepository().getName());
    }

    protected CommitterUserMappingManager getCommitterUserMappingManager() {
        if (this.committerUserMappingManager == null) {
            this.committerUserMappingManager = (CommitterUserMappingManager)SpringContext.getComponent("committerUserMappingManager");
        }
        return this.committerUserMappingManager;
    }

    public BaseAction processRequest(BaseActionParams params) throws IOException, DbException, ServletException {
        try {
            return this.handleRequest(params);
        }
        catch (PathNotFoundException e2) {
            this.send404(e2.getMessage());
            return null;
        }
    }

    public abstract BaseAction handleRequest(BaseActionParams var1) throws ServletException, IOException, DbException;

    protected void send404(String msg) throws IOException {
        ServletUtils.send404(this.getRequest(), this.getResponse(), msg);
    }

    protected void sendFileDeleted(FileRevision rev, ViewFileActionParams params) throws IOException, ServletException {
        Logs.APP_LOG.info((Object)("404: " + rev.getPath() + " of revision " + rev.getRevision() + " deleted. Referer=" + this.getRequest().getHeader("Referer")));
        params.setFileRevision(rev);
        this.getResponse().setStatus(404);
        this.getRequest().getRequestDispatcher("/WEB-INF/jsp/annotate_not_found.jsp").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
    }

    protected boolean handleWatches(String mmodeUrl, WatchParams params) throws IOException {
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        HttpServletResponse res = this.getResponse();
        Path lPath = pi.getLocalPath();
        UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(req);
        if (user != null) {
            WatchManager wm = AppConfig.getsConfig().getWatchManager();
            String watchParam = req.getParameter("watch");
            if (watchParam != null) {
                boolean toggled = false;
                if ("on".equals(watchParam)) {
                    try {
                        Logs.APP_LOG.debug((Object)String.format("Removing watch for user [%s] for path [%s:%s]", user.getUserName(), this.repName, lPath));
                        wm.deleteWatch(user.getUsername(), this.repName, lPath, this.waybackSpec);
                        Logs.APP_LOG.debug((Object)String.format("Adding watch for user [%s] for path [%s:%s] with spec [%s]", user.getUserName(), this.repName, lPath, this.waybackSpec));
                        wm.addWatch(user.getUsername(), this.repName, lPath, this.waybackSpec);
                    }
                    catch (DbException e2) {
                        Logs.APP_LOG.error((Object)"Error adding watch", (Throwable)e2);
                    }
                    PreferenceManager.touchCookie(req, res);
                    toggled = true;
                } else if ("off".equals(watchParam)) {
                    try {
                        Logs.APP_LOG.debug((Object)String.format("Removing watch for user [%s] for path [%s:%s]", user.getUserName(), this.repName, lPath));
                        wm.deleteWatch(user.getUsername(), this.repName, lPath, this.waybackSpec);
                    }
                    catch (DbException e3) {
                        Logs.APP_LOG.error((Object)"Error deleting watch", (Throwable)e3);
                    }
                    PreferenceManager.touchCookie(req, res);
                    toggled = true;
                }
                if (toggled) {
                    String url = req.getContextPath() + mmodeUrl + (this.waybackSpec != null ? this.waybackSpec.getUrlCommand() : "") + "/" + pi.getFullPath().getAsUrl();
                    this.getResponse().sendRedirect(url);
                    return true;
                }
            }
            params.setWatching(this.isWatching(lPath, this.waybackSpec));
        }
        return false;
    }

    protected boolean isWatching(Path path, WaybackSpec wb) {
        try {
            UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(this.getRequest());
            if (user != null) {
                WatchManager wm = AppConfig.getsConfig().getWatchManager();
                Watch watch = wm.getWatch(user.getUsername(), this.repName, path, wb);
                return watch != null;
            }
            return false;
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Error accessing watch", (Throwable)e2);
            return false;
        }
    }

    public void handleNoRepository(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ServletUtils.send404(req, resp, "Please specify a repository.");
    }

    public void handleBadPath(HttpServletRequest req, HttpServletResponse resp, Path localPath) throws IOException {
        ServletUtils.send404(req, resp, "Path \"" + localPath + "\" does not exist.");
    }

    public boolean requiresValidPath(FishEyePathInfo pi) {
        return true;
    }
}

