/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityRequestConstants;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ActivityStreamServlet
extends HttpServlet {
    private UserManager userManager;
    private GlobalPermissionService globalPermissionService;
    private UserProfileManager userProfileManager;
    private RepositoryManager repositoryManager;
    private CommitterUserMappingManager committerUserMappingManager;

    public void init() throws ServletException {
        super.init();
        this.repositoryManager = SpringContext.getComponentByClass(RepositoryManager.class);
        this.userProfileManager = SpringContext.getComponentByClass(UserProfileManager.class);
        this.userManager = SpringContext.getComponentByClass(UserManager.class);
        this.globalPermissionService = SpringContext.getComponentByClass(GlobalPermissionService.class);
        this.committerUserMappingManager = SpringContext.getComponentByClass(CommitterUserMappingManager.class);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserLogin current;
        if (AppConfig.isCrucibleOnly()) {
            ServletUtils.send404(request, response, "FishEye License Required");
            return;
        }
        long timeout = ServletUtils.parseLongFromRequest("timeout", ActivityRequestConstants.DEFAULT_TIMEOUT_SHORT, request);
        ActivitySearchMonitor activitySearchMonitor = new ActivitySearchMonitor(timeout);
        request.setAttribute("activitySearchMonitor", (Object)activitySearchMonitor);
        if (request.getParameter("home") != null) {
            request.setAttribute("home", (Object)"home");
        }
        Object user = (current = this.userManager.getCurrentUser(request)) == null ? Principal.Anonymous.ANON : current;
        int itemsPerPage = this.determineItemsPerPage(request, (Principal)user);
        String view = request.getParameter("view") == null ? PreferenceManager.getPreference(request, "activityStreamView") : request.getParameter("view");
        ActivityItemSearchParams params = ActivityStreamHandler.constructSearchParams(request, itemsPerPage, AppConfig.getsConfig().getTimezone(), view);
        ActivityStreamHandler handler = new ActivityStreamHandler(this.globalPermissionService, this.repositoryManager, activitySearchMonitor, this.committerUserMappingManager);
        handler.handleActivityStream(request, response, params, (Principal)user, itemsPerPage, view, false);
    }

    private int determineItemsPerPage(HttpServletRequest request, Principal user) {
        int itemsPerPage = 30;
        if (user != null) {
            try {
                UserProfile profile = !Principal.Anonymous.isAnon((Principal)user) ? this.userProfileManager.getProfile(user.getUserName()) : UserProfileManager.DEFAULT_PROFILE;
                itemsPerPage = profile.getChangesetsPerPage();
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("Database exception thrown when access user profile for " + user.getUserName()), (Throwable)e2);
            }
        }
        if (request.getParameter("max") != null) {
            try {
                int max = Integer.parseInt(request.getParameter("max"), 10);
                itemsPerPage = Math.min(max, 100);
            }
            catch (NumberFormatException e3) {
                Logs.APP_LOG.warn((Object)("NumberFormatException for param max in activityStreamHandler:" + request.getParameter("max")), (Throwable)e3);
            }
        }
        return itemsPerPage;
    }
}

