/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.fisheye.user.RecentlyVisitedManager;
import com.atlassian.fisheye.user.model.RecentlyVisitedItem;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.ChangelogAjaxServlet;
import com.cenqua.fisheye.web.ChangelogServlet;
import com.cenqua.fisheye.web.ChartPageAction;
import com.cenqua.fisheye.web.CommitterPageAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.LoginServlet;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.SearchRepositoryServlet;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.ViewRepositoryServlet;
import com.cenqua.fisheye.web.filehist.PerLineHistoryAction;
import com.cenqua.fisheye.web.parameterbeans.BaseActionParams;
import com.cenqua.fisheye.web.rdiff.RDiffAction;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ActionDispatcherServlet
extends HttpServlet {
    private static final Map<String, Class<? extends BaseAction>> ACTION_MAP = new HashMap<String, Class<? extends BaseAction>>();
    private static final Collection<Class<? extends BaseAction>> STORE_HISTORY_SET = new HashSet<Class<? extends BaseAction>>();
    public static final String STATIC_DIR = "static/" + FisheyeVersionInfo.BUILD_STAMP;
    RecentlyVisitedManager recentlyVisitedManager;
    public static final String CHANGELOG_AJAX = "changelog-ajax";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.doIt(req, resp);
        }
        catch (ServletException e2) {
            Throwable rc = e2.getRootCause();
            Throwable rc2 = null;
            if (rc != null) {
                rc2 = rc.getCause();
            }
            if (!this.squashExceptions(e2, rc, rc2)) {
                while (rc != null) {
                    Logs.APP_LOG.info((Object)"Servlet Exception, rootcause=", rc);
                    if (rc instanceof ServletException) {
                        rc = ((ServletException)rc).getRootCause();
                        continue;
                    }
                    rc = null;
                }
                throw e2;
            }
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)"Error handling request", (Throwable)e3);
            throw e3;
        }
    }

    private boolean squashExceptions(ServletException e2, Throwable cause1, Throwable cause2) {
        if (cause2 != null && cause2.getMessage() != null && (cause2.getMessage().equalsIgnoreCase("Connection reset by peer") || cause2.getMessage().equalsIgnoreCase("Broken pipe"))) {
            Logs.APP_LOG.debug((Object)("Exception in client request: " + ((Object)((Object)e2)).getClass() + ": " + e2.getMessage()));
            Logs.APP_LOG.debug((Object)("caused by " + cause1.getClass() + ": " + cause1.getMessage() + ", caused by " + cause2.getClass() + ": " + cause2.getMessage()));
            Logs.APP_LOG.debug((Object)"Request probably timed out or was cancelled by the client");
            return true;
        }
        return false;
    }

    protected void doIt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RootConfig rootConfig = AppConfig.getsConfig();
        Disposer.pushThreadInstance();
        try {
            UserLogin user;
            BaseAction action;
            Class<? extends BaseAction> actionClass;
            String actionName = req.getServletPath();
            if (actionName.startsWith("/")) {
                actionName = actionName.substring(1);
            }
            if ((actionClass = ACTION_MAP.get(actionName)) == null) {
                Logs.APP_LOG.info((Object)("unknown action " + actionName + " referer=" + req.getHeader("Referer")));
                ServletUtils.send404(req, resp, "unknown action " + actionName);
                return;
            }
            if (AppConfig.isCrucibleOnly() && !CHANGELOG_AJAX.equals(actionName)) {
                ServletUtils.send404(req, resp, "Page not found");
                return;
            }
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("mapped action " + actionName + " to " + actionClass + " pi = " + req.getPathInfo()));
            }
            FishEyePathInfo piHelper = this.parsePathInfo(req);
            try {
                action = SpringContext.createComponent(actionClass);
            }
            catch (Exception e2) {
                throw new ServletException("error with action " + actionName, (Throwable)e2);
            }
            String repname = piHelper.getRepname();
            if (piHelper.isEmpty()) {
                action.handleNoRepository(req, resp);
                return;
            }
            RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
            if (h2 == null) {
                ServletUtils.send404(req, resp, "No such repository: " + repname);
                return;
            }
            UserManager um = rootConfig.getUserManager();
            if (!um.hasPermissionToAccess(user = um.getCurrentUser(req), h2)) {
                if (user == null) {
                    LoginServlet.redirectToLogin(req, resp);
                } else {
                    ServletUtils.send403(req, resp, "You are not allowed to access the repository " + repname);
                }
                return;
            }
            if (!h2.getCfg().isEnabled()) {
                ServletUtils.sendRepositoryNotEnabled(req, resp, h2);
                return;
            }
            if (!h2.isRunning()) {
                ServletUtils.sendRepositoryNotRunning(req, resp, h2);
                return;
            }
            piHelper.initEngine(h2);
            if (action.requiresValidPath(piHelper) && !piHelper.pathExists()) {
                action.handleBadPath(req, resp, piHelper.getLocalPath());
                return;
            }
            RepositoryConfig rcfg = piHelper.getRepository();
            BaseActionParams baseParams = new BaseActionParams(rcfg.getName(), PreferenceManager.getPreferences(req));
            req.setAttribute("p", (Object)baseParams);
            req.setAttribute("RepositoryConfig", (Object)baseParams.getRepositoryConfig());
            req.setAttribute("RepositoryEngine", (Object)baseParams.getRepositoryEngine());
            if (!Principal.Anonymous.isAnon((Principal)user) && STORE_HISTORY_SET.contains(actionClass)) {
                this.recentlyVisitedManager = SpringContext.getComponentByClass(RecentlyVisitedManager.class);
                this.recentlyVisitedManager.addItemToHistory(RecentlyVisitedItem.Type.REPOSITORY, um.getUserFor(user), h2.getName());
            }
            while (action != null) {
                long lastMod;
                boolean skipLastMod;
                action.setupInternal(piHelper, req, resp, this.getServletContext(), baseParams);
                action.setup();
                boolean bl = skipLastMod = !ActionDispatcherServlet.isHeadOrGet(req) || this.inTourMode(req);
                if (!skipLastMod && (lastMod = action.computeLastModified()) != -1L) {
                    long ifModSince;
                    lastMod = Math.max(lastMod, AppConfig.getLastModified());
                    if (baseParams.getUserPrefs().getLastModified() != null) {
                        lastMod = Math.max(lastMod, baseParams.getUserPrefs().getLastModified());
                    }
                    if ((ifModSince = req.getDateHeader("If-Modified-Since")) != -1L && ifModSince >= lastMod / 1000L * 1000L) {
                        resp.setStatus(304);
                        return;
                    }
                    resp.setDateHeader("Last-Modified", lastMod);
                }
                action = action.processRequest(baseParams);
            }
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)"problem during request", (Throwable)e3);
            throw new ServletException((Throwable)e3);
        }
        catch (RepositoryHandle.StateException e4) {
            Logs.APP_LOG.warn((Object)"problem during request", (Throwable)((Object)e4));
            throw new ServletException((Throwable)((Object)e4));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private FishEyePathInfo parsePathInfo(HttpServletRequest req) throws ServletException {
        FishEyePathInfo pi = new FishEyePathInfo(req);
        if (pi.getFullPath().isAbove()) {
            throw new ServletException("Relative path specified " + pi.getFullPath());
        }
        return pi;
    }

    private boolean inTourMode(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            return false;
        }
        Object fegState = session.getAttribute("FETOUR");
        return fegState != null;
    }

    private static boolean isHeadOrGet(HttpServletRequest req) {
        return req.getMethod().equals("GET") || req.getMethod().equals("HEAD");
    }

    static {
        ACTION_MAP.put("viewrep", ViewRepositoryServlet.class);
        ACTION_MAP.put("browse", ViewRepositoryServlet.class);
        ACTION_MAP.put("search", SearchRepositoryServlet.class);
        ACTION_MAP.put("changelog", ChangelogServlet.class);
        ACTION_MAP.put(CHANGELOG_AJAX, ChangelogAjaxServlet.class);
        ACTION_MAP.put("rdiff", RDiffAction.class);
        ACTION_MAP.put("chart", ChartPageAction.class);
        ACTION_MAP.put("committer", CommitterPageAction.class);
        ACTION_MAP.put("line-history", PerLineHistoryAction.class);
        STORE_HISTORY_SET.add(ViewRepositoryServlet.class);
        STORE_HISTORY_SET.add(SearchRepositoryServlet.class);
        STORE_HISTORY_SET.add(ChangelogServlet.class);
        STORE_HISTORY_SET.add(CommitterPageAction.class);
    }
}

