/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualisationPref {
    private final String repoName;
    private final Set<String> branches;
    private final Mode mode;
    private final String highlighterName;

    private VisualisationPref(String repoName, Set<String> branches, String highlighterName, Mode mode) {
        this.repoName = repoName;
        this.branches = branches;
        this.highlighterName = highlighterName;
        this.mode = mode;
    }

    private VisualisationPref() {
        this(null, null, null, Mode.CUSTOM);
    }

    public Set<String> getBranchSet() {
        return this.branches;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getHighlighterName() {
        return this.highlighterName;
    }

    public static VisualisationPref defaultVisualisationPref() {
        return new VisualisationPref();
    }

    public static VisualisationPref newVisualisationPref(String repName, Set<String> branches, String highlighterName, Mode mode) {
        return new VisualisationPref(repName, branches, highlighterName, mode);
    }

    public static Set<String> getVisualisationBranches(JSONObject branchPref, String repName) {
        try {
            JSONObject branchsetCookie = branchPref.getJSONObject(repName);
            JSONArray branchArray = branchsetCookie.getJSONArray("bl");
            LinkedHashSet branches = Sets.newLinkedHashSet();
            for (int index = 0; index < branchArray.length(); ++index) {
                branches.add(branchArray.getString(index));
            }
            return branches;
        }
        catch (JSONException e2) {
            Logs.APP_LOG.warn((Object)"Error getting set of branches from preference. Default branches will be used.", (Throwable)e2);
            return null;
        }
    }

    public static String getVisualisationHighlight(JSONObject highlighterPref, String repName) {
        try {
            return highlighterPref.getJSONObject(repName).getString("hl");
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Mode getVisualisationMode(JSONObject branchPref, String repName) {
        try {
            return Mode.fromJSONString(branchPref.getJSONObject(repName).getString("m"));
        }
        catch (Exception e2) {
            return Mode.CUSTOM;
        }
    }

    public static enum Mode {
        ALL,
        CUSTOM;


        public static Mode fromJSONString(String value) {
            for (Mode mode : Mode.values()) {
                if (!mode.name().startsWith(value)) continue;
                return mode;
            }
            throw new IllegalArgumentException("No Mode found for String: " + value);
        }

        public boolean isAll() {
            return ALL == this;
        }

        public boolean isCustom() {
            return CUSTOM == this;
        }
    }
}

