/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.jira.JiraServerService;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.plugin.descriptor.VisHighlightPluginModuleDescriptor;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.vis.BaseCommitGraphAction;
import com.cenqua.fisheye.vis.VisualisationPref;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

public class ViewCommitGraphAction
extends BaseCommitGraphAction {
    public static final String VIEW_GRAPH_PATH = "graph";
    private static final int MAX_RECENT_BRANCHES = 5;
    private static final int MAX_COMMITS_TO_WALK = 100;
    private EffectiveUserProvider effectiveUserProvider;
    private final PluginAccessor pluginAccessor;
    private final JiraServerService jiraServerService;
    private final ChangesetCommentManager changesetCommentManager;
    private final UserRepositoryPropertyManager propertyManager;
    private String csid;
    private CookiePreferences preferences;
    private ChangeSetHolder changesetHolder;
    private ChangeSet changeset;
    private Set<String> branches;
    private Set<String> recentlyActiveBranches;
    private VisualisationPref visualisationPref;
    protected TxTemplate txTemplate;
    private String vbs;
    private String vhl;
    private static Map<ScmType, Set<String>> ignoredBranches = Maps.newHashMap();
    private final CommitterUserMappingManager committerUserMappingManager;

    public ViewCommitGraphAction() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    @Autowired
    public ViewCommitGraphAction(RepositoryManager repositoryManager, UserManager userManager, EffectiveUserProvider effectiveUserProvider, PluginAccessor pluginAccessor, JiraServerService jiraServerService, RootConfig rootConfig, ChangesetCommentManager changesetCommentManager, UserRepositoryPropertyManager propertyManager, TxTemplate txTemplate, CommitterUserMappingManager committerUserMappingManager) {
        super(repositoryManager, userManager, effectiveUserProvider, rootConfig);
        this.effectiveUserProvider = effectiveUserProvider;
        this.pluginAccessor = pluginAccessor;
        this.jiraServerService = jiraServerService;
        this.changesetCommentManager = changesetCommentManager;
        this.propertyManager = propertyManager;
        this.txTemplate = txTemplate;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    public void setVhl(String vhl) {
        this.vhl = vhl;
    }

    public void setVbs(String vbs) {
        this.vbs = vbs;
    }

    public String doSaveBranchSet() throws JSONException {
        JSONObject json;
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (user == null) {
            return null;
        }
        String repoName = this.getRepositoryName();
        if (this.vbs != null) {
            json = new JSONObject(this.vbs);
            Set<String> branches = VisualisationPref.getVisualisationBranches(json, repoName);
            VisualisationPref.Mode mode = VisualisationPref.getVisualisationMode(json, repoName);
            JSONArray branchSet = new JSONArray(branches);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("visualisation.mode", mode == null ? null : mode.name());
            properties.put("visualisation.branchset", branches == null ? null : branchSet.toString());
            this.propertyManager.saveProperties(user, repoName, properties);
        }
        if (this.vhl != null) {
            json = new JSONObject(this.vhl);
            String highlight = VisualisationPref.getVisualisationHighlight(json, repoName);
            this.propertyManager.saveProperty(user, repoName, "visualisation.highlight", highlight);
        }
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doViewCommitGraph() {
        String ret = this.execute();
        if (!"success".equals(ret)) {
            return ret;
        }
        if (!Strings.isNullOrEmpty((String)this.getCsid())) {
            Tag tag;
            RevisionCache revisionCache = this.getRevisionCache();
            this.changeset = revisionCache.getChangeSet(this.getCsid());
            if (this.changeset == null && (tag = revisionCache.getTag(this.getCsid())) != null) {
                this.changeset = revisionCache.getChangeSet(tag.getChangesetId());
            }
        }
        this.visualisationPref = this.buildVisualisationPref();
        return "success";
    }

    @RequireSecurityToken(value=false)
    public String doMoreInfo() {
        String ret = this.execute();
        if (!"success".equals(ret)) {
            return ret;
        }
        RevisionCache revisionCache = this.getRevisionCache();
        Object changeset = revisionCache.getChangeSet(this.getCsid());
        if (changeset == null) {
            return "error";
        }
        WaybackSpec waybackSpec = new WaybackSpec();
        RepositoryConfig repositoryConfig = this.getRepositoryHandle().getCfg();
        this.changesetHolder = new ChangeSetHolder((ChangeSet)changeset, new ChangeSetHolder.Context(waybackSpec, revisionCache.isCaseSensitive(), 15, Path.ROOT, this.getRepositoryName(), repositoryConfig.getRepositoryType(), revisionCache.getDefaultBranch()), repositoryConfig.isSupportsBranchFilter(), this.committerUserMappingManager);
        this.changesetHolder.setComments(this.changesetCommentManager.getCommentsForChangeset(changeset.getRepName(), changeset.getId()));
        return "success";
    }

    public Set<String> getBranches() {
        VisualisationPref visPref;
        if (this.branches == null && (visPref = this.getVisualisationPref()) != null) {
            this.branches = visPref.getBranchSet();
            if (this.branches == null) {
                this.branches = this.getRecentlyActiveBranches();
            }
        }
        return this.branches;
    }

    public String getBranchForChangeset() {
        if (this.getChangeset() != null) {
            return this.getChangeset().getBranch();
        }
        return null;
    }

    @Nullable
    public String getDefaultBranchName() {
        return this.getRevisionCache().getDefaultBranch();
    }

    public boolean isRecentlyActiveBranchLimitExceeded() {
        int branchCount = Sets.filter(this.getRevisionCache().getBranches(), Branch.NOT_REMOVED).size();
        return branchCount > FishEyeSysProps.RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT;
    }

    private <E> boolean containsAny(Collection<E> c1, Collection<E> c2) {
        for (E item : c2) {
            if (!c1.contains(item)) continue;
            return true;
        }
        return false;
    }

    public VisualisationPref.Mode getBranchMode() {
        return this.getVisualisationPref().getMode();
    }

    public String getHighlighterName() {
        return this.getVisualisationPref().getHighlighterName();
    }

    public VisualisationPref getVisualisationPref() {
        return this.visualisationPref;
    }

    public VisualisationPref buildVisualisationPref() {
        final FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        if (user == null) {
            PreferenceManager.clearVisualisationPrefs(user, CrucibleFilter.getRequest(), CrucibleFilter.getResponse(), this.preferences);
            return null;
        }
        if (!this.preferences.getVisualisationRepositories().isEmpty()) {
            this.txTemplate.execute(new TxCallback<Void>(){

                @Override
                public Void doInTransaction(TransactionStatus status) throws Exception {
                    for (String repoName : ViewCommitGraphAction.this.preferences.getVisualisationRepositories()) {
                        VisualisationPref pref = ViewCommitGraphAction.this.preferences.getVisualisationPref(repoName);
                        JSONArray branchSet = new JSONArray(pref.getBranchSet());
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("visualisation.mode", pref.getMode() == null ? null : pref.getMode().name());
                        properties.put("visualisation.highlight", pref.getHighlighterName());
                        properties.put("visualisation.branchset", branchSet.toString());
                        ViewCommitGraphAction.this.propertyManager.saveProperties(user, repoName, properties);
                    }
                    PreferenceManager.clearVisualisationPrefs(user, CrucibleFilter.getRequest(), CrucibleFilter.getResponse(), ViewCommitGraphAction.this.preferences);
                    return null;
                }
            });
        }
        Map<String, String> properties = this.propertyManager.loadProperties(user, this.getRepositoryName());
        String mode = properties.get("visualisation.mode");
        String highlight = properties.get("visualisation.highlight");
        String branchesValue = properties.get("visualisation.branchset");
        LinkedHashSet branches = Sets.newLinkedHashSet();
        try {
            if (branchesValue != null) {
                JSONArray branchArray = new JSONArray(branchesValue);
                for (int index = 0; index < branchArray.length(); ++index) {
                    branches.add(branchArray.getString(index));
                }
            } else {
                branches = null;
            }
        }
        catch (JSONException e2) {
            Logs.APP_LOG.warn((Object)("Error retrieving branch preferences for user: " + user.getUsername() + ", value was '" + branchesValue + "'. Default branches will be used."), (Throwable)e2);
        }
        return VisualisationPref.newVisualisationPref(this.getRepositoryName(), branches, highlight, mode == null ? VisualisationPref.Mode.CUSTOM : VisualisationPref.Mode.valueOf(mode));
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        super.setServletRequest(request);
        this.preferences = PreferenceManager.getPreferences(request);
    }

    public String getCsid() {
        return this.csid;
    }

    public void setCsid(String csid) {
        this.csid = csid;
    }

    public List<String> getHighlighters() {
        return Lists.transform((List)this.pluginAccessor.getEnabledModuleDescriptorsByClass(VisHighlightPluginModuleDescriptor.class), (Function)new Function<VisHighlightPluginModuleDescriptor, String>(){

            public String apply(VisHighlightPluginModuleDescriptor from) {
                return from.getCompleteKey();
            }
        });
    }

    public ChangeSetHolder getChangesetHolder() {
        return this.changesetHolder;
    }

    public Set<String> getRecentlyActiveBranches() {
        if (this.recentlyActiveBranches == null) {
            this.recentlyActiveBranches = new LinkedHashSet<String>();
            String defaultBranch = this.getRevisionCache().getDefaultBranch();
            if (!Strings.isNullOrEmpty((String)defaultBranch)) {
                this.recentlyActiveBranches.add(defaultBranch);
            }
            int c2 = 0;
            ListIterator iterator = this.getRevisionCache().getChangeSets().iteratorFromEnd();
            ScmType repositoryType = this.getRepositoryHandle().getCfg().getRepositoryType();
            Set<String> ignore = ignoredBranches.get((Object)repositoryType);
            while (iterator.hasPrevious() && this.recentlyActiveBranches.size() < 5 && c2 < 100) {
                Set<String> csBranches = ((ChangeSet)iterator.previous()).getBranches();
                for (String csBranch : csBranches) {
                    if (ignore != null && ignore.contains(csBranch)) continue;
                    this.recentlyActiveBranches.add(csBranch);
                }
            }
        }
        return this.recentlyActiveBranches;
    }

    public boolean isJiraServerLinked() {
        return this.jiraServerService.hasJiraApplicationLink();
    }

    public String getDefaultAvatarUrl() {
        return AvatarTypeInfo.getFullUnknownAvatarUrl(null);
    }

    public ChangeSet getChangeset() {
        return this.changeset;
    }

    static {
        ignoredBranches.put(ScmType.SVN, Sets.newHashSet((Object[])new String[]{"root:"}));
    }
}

