/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.vis.ChartLocation;
import com.cenqua.fisheye.vis.LocChartParams;
import com.cenqua.fisheye.vis.SidebarChartData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class SidebarChartDataCalculator {
    public SidebarChartData getUserData(HttpServletRequest request, Principal currentUser, int locChartWidth, String username) throws DbException {
        TimeZone tz = AppConfig.getUserTimeZone(request);
        UserManager userManager = AppConfig.getsConfig().getUserManager();
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        CommitterUserMappingManager committerMappingManager = (CommitterUserMappingManager)SpringContext.getComponent("committerUserMappingManager");
        Multimap<String, String> committers = committerMappingManager.getAllCommittersForUser(username);
        for (RepositoryHandle rep : rm.getHandles()) {
            if (rep.isRunning() && userManager.hasPermissionToAccess(currentUser, rep)) continue;
            committers.removeAll((Object)rep.getName());
        }
        ArrayList<SeriesDetails> series = new ArrayList<SeriesDetails>();
        for (String rep : committers.keySet()) {
            SeriesDetails s2 = new SeriesDetails();
            s2.setLabelShort(rep);
            s2.setLabelLong(this.formatUserLabel(rep, committers.get((Object)rep)));
            ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
            builder.maxItems(1).timeZone(tz).includeCrucible();
            for (String committer : committers.get((Object)rep)) {
                builder.anyCommitter(rep, committer);
            }
            s2.setCommitParams(builder.build());
            ParameterSetQuery queryParams = new ParameterSetQuery();
            queryParams.setAuthors((List<String>)ImmutableList.copyOf((Collection)committers.get((Object)rep)));
            s2.setLocParams(queryParams);
            s2.setRepHandle(rm.getRepository(rep));
            series.add(s2);
        }
        return this.getData(series, locChartWidth);
    }

    private SidebarChartData getData(List<SeriesDetails> seriesList, int locChartWidth) throws DbException {
        SidebarChartData data = new SidebarChartData();
        BucketDataCollectionTotalled locData = new BucketDataCollectionTotalled(PeriodUnit.DAY, TimeZone.getDefault());
        for (SeriesDetails series : seriesList) {
            try {
                RepositoryEngine engine = series.repHandle.acquireEngine();
                data.addSeriesLabelShort(series.labelShort);
                data.addSeriesLabelLong(series.labelLong);
                ChangesetStatsCalculator calculator = engine.makeChangesetHistoryCalculator(series.commitParams);
                LuceneConnection<CrossRepLuceneIndexes> luceneConnection = engine.getCrossRepLuceneConnection();
                SumMap<String> map = ChangesetIndexer.getEmptyWeekMapForLastYear();
                data.addSparkline(calculator.getCommitVolumeForPastYearByWeek(luceneConnection, map));
                data.addCommitsByDay(calculator.activityByDay(luceneConnection));
                TimeZone repTimeZone = DateHelper.GMT;
                double offset = (long)(-(repTimeZone.getRawOffset() - series.commitParams.getTz().getRawOffset())) / 3600000L;
                data.addCommitsByHour(calculator.activityByHour(luceneConnection, offset));
                calculator.activityCalendar(luceneConnection, data.getCalendar());
                BucketGraph bucketGraph = engine.getBucketGraph();
                BucketDataCollectionTotalled repData = bucketGraph.getBuckets(series.locParams);
                Object first = repData.getFirst();
                if (first != null) {
                    if (!engine.getCfg().isAuthorLocEnabled() && !series.locParams.isAllAuthors()) {
                        ((BucketData)first).zeroLinecount();
                    }
                    ((BucketData)first).setLabel(series.labelLong);
                    locData.add(repData.getFirst());
                    continue;
                }
                locData.add(new BucketDataTotalled(series.labelShort));
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.debug((Object)"Bad repository state", (Throwable)((Object)e2));
            }
        }
        LocChartParams locParams = ChartLocation.SIDEBAR.getParams();
        locParams.setDimension(locChartWidth, null);
        CalculatedBucketGraphXY graphs = new CalculatedBucketGraphXY(locData, false, null, null, "", locParams, 20, false, null, BreakdownOption.NONE, true, false);
        data.addLocData(graphs);
        return data;
    }

    private String formatUserLabel(String rep, Collection<String> committers) {
        StringBuilder sb = new StringBuilder("Committer");
        if (committers.size() > 1) {
            sb.append("s");
        }
        sb.append(" ").append(StringUtil.formatList((List<String>)ImmutableList.copyOf(committers))).append(" in ").append(rep);
        return sb.toString();
    }

    private String formatUserLabel(String rep, String committer) {
        StringBuilder sb = new StringBuilder("Committer ").append(committer).append(" in ").append(rep);
        return sb.toString();
    }

    public SidebarChartData getCommitterData(HttpServletRequest request, Principal currentUser, int locChartWidth, String rep, String committer) throws DbException {
        RepositoryHandle repHandle;
        TimeZone tz = AppConfig.getUserTimeZone(request);
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        UserManager userManager = AppConfig.getsConfig().getUserManager();
        if (userManager.hasPermissionToAccess(currentUser, repHandle = rm.getRepository(rep))) {
            SeriesDetails s2 = new SeriesDetails();
            s2.setLabelShort(rep);
            s2.setLabelLong(this.formatUserLabel(rep, committer));
            ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
            builder.maxItems(1).timeZone(tz).includeCrucible();
            builder.anyCommitter(rep, committer);
            s2.setCommitParams(builder.build());
            ParameterSetQuery queryParams = new ParameterSetQuery();
            queryParams.setAuthor(committer);
            s2.setLocParams(queryParams);
            s2.setRepHandle(repHandle);
            return this.getData(Arrays.asList(s2), locChartWidth);
        }
        return new SidebarChartData();
    }

    private static class SeriesDetails {
        private String labelShort;
        private String labelLong;
        private ActivityItemSearchParams commitParams;
        private ParameterSetQuery locParams;
        private RepositoryHandle repHandle;

        private SeriesDetails() {
        }

        public void setLabelShort(String labelShort) {
            this.labelShort = labelShort;
        }

        public void setLabelLong(String labelLong) {
            this.labelLong = labelLong;
        }

        public void setCommitParams(ActivityItemSearchParams commitParams) {
            this.commitParams = commitParams;
        }

        public void setLocParams(ParameterSetQuery locParams) {
            this.locParams = locParams;
        }

        public void setRepHandle(RepositoryHandle repHandle) {
            this.repHandle = repHandle;
        }
    }
}

