/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.csindex.ActivityCalendar;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;

public class SidebarChartData {
    private final ActivityCalendar calendar = new ActivityCalendar();
    private final JSONArray commitsByDay = new JSONArray();
    private final JSONArray commitsByHour = new JSONArray();
    private final JSONArray locDataX = new JSONArray();
    private final JSONArray locDataY = new JSONArray();
    private final JSONArray seriesLabelsLong = new JSONArray();
    private final JSONArray seriesLabelsShort = new JSONArray();
    private final JSONArray sparklineData = new JSONArray();
    private final JSONArray sparklineLabels = new JSONArray();

    public void addCommitsByDay(Object2IntMap<String> stringObject2IntMap) {
        this.commitsByDay.put((Object)this.valuesToJsonArray(stringObject2IntMap));
    }

    public void addCommitsByHour(Object2IntMap<String> stringObject2IntMap) {
        this.commitsByHour.put((Object)this.valuesToJsonArray(stringObject2IntMap));
    }

    private JSONArray valuesToJsonArray(Object2IntMap<String> stringObject2IntMap) {
        return new JSONArray((Collection)stringObject2IntMap.values());
    }

    public void addLocData(CalculatedBucketGraphXY graphs) {
        XYSeriesCollection data = graphs.getLinecountCollection();
        for (int i2 = 0; i2 < data.getSeriesCount(); ++i2) {
            XYSeries series = data.getSeries(i2);
            JSONArray array = new JSONArray();
            for (int j2 = 0; j2 < series.getItemCount(); ++j2) {
                if (i2 == 0) {
                    this.locDataX.put(series.getX(j2).longValue());
                }
                array.put(series.getY(j2).intValue());
            }
            this.locDataY.put((Object)array);
        }
    }

    public ActivityCalendar getCalendar() {
        return this.calendar;
    }

    public String getCommitsByDayJson() throws JSONException {
        return this.commitsByDay.toString();
    }

    public String getCommitsByHourJson() throws JSONException {
        return this.commitsByHour.toString();
    }

    public String getLocDataXJson() throws JSONException {
        return this.locDataX.toString();
    }

    public String getLocDataYJson() throws JSONException {
        return this.locDataY.toString();
    }

    public String getSeriesLabelsLongJson() throws JSONException {
        return new JSONArray((Object)this.seriesLabelsLong).toString();
    }

    public void addSparkline(Object2IntMap<String> data) {
        if (this.sparklineLabels.length() == 0) {
            this.sparklineLabels.put((Collection)data.keySet());
        }
        this.sparklineData.put((Object)this.valuesToJsonArray(data));
    }

    public String getSparklineDataJson() throws JSONException {
        return this.sparklineData.toString();
    }

    public String getSparklineLabelsJson() throws JSONException {
        return new JSONArray((Object)this.sparklineLabels).toString();
    }

    public String getSeriesLabelsShortJson() throws JSONException {
        JSONArray json = new JSONArray((Object)this.seriesLabelsShort);
        return json.toString();
    }

    public String getActivityCalendarYearsJson() {
        JSONArray json = this.getActivityCalendarYears();
        return json.toString();
    }

    private JSONArray getActivityCalendarYears() {
        JSONArray json = new JSONArray();
        for (ActivityCalendar.Year year : this.calendar.getYears()) {
            json.put(year.getYear());
        }
        return json;
    }

    public String getActivityCalendarDataJson() {
        JSONArray json = this.getActivityCalendarData();
        return json.toString();
    }

    private JSONArray getActivityCalendarData() {
        JSONArray json = new JSONArray();
        for (ActivityCalendar.Year year : this.calendar.getYears()) {
            JSONArray json2 = new JSONArray();
            for (ActivityCalendar.Month month : year.getMonths()) {
                json2.put(month.getCount());
            }
            json.put((Object)json2);
        }
        return json;
    }

    public void addSeriesLabelShort(String label) {
        this.seriesLabelsShort.put((Object)label);
    }

    public void addSeriesLabelLong(String label) {
        this.seriesLabelsLong.put((Object)label);
    }

    public void writeJson(OutputStreamWriter writer) throws JSONException, IOException {
        JSONWriter jWriter = new JSONWriter((Writer)writer);
        jWriter.object();
        jWriter.key("seriesLabelsShort").value((Object)this.seriesLabelsShort);
        jWriter.key("seriesLabelsLong").value((Object)this.seriesLabelsLong);
        jWriter.key("commitsByDay").value((Object)this.commitsByDay);
        jWriter.key("commitsByHour").value((Object)this.commitsByHour);
        jWriter.key("locDataX").value((Object)this.locDataX);
        jWriter.key("locDataY").value((Object)this.locDataY);
        jWriter.key("activityCalendarYears").value((Object)this.getActivityCalendarYears());
        jWriter.key("activityCalendarData").value((Object)this.getActivityCalendarData());
        jWriter.key("sparklineLabels").value((Object)this.sparklineLabels);
        jWriter.key("sparklineData").value((Object)this.sparklineData);
        jWriter.endObject();
        writer.append("\n");
        writer.close();
    }
}

