/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.vis.BranchTable;
import com.cenqua.fisheye.vis.DrawContext;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import com.cenqua.fisheye.vis.Graph;
import com.cenqua.fisheye.vis.HistoryRenderer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class RevisionHistVisualiser {
    private final FileHistory mHistory;
    private Graph mGraph;
    private BranchTable mTable;

    public RevisionHistVisualiser(FileHistory history) {
        this.mHistory = history;
        this.mGraph = new Graph(this.mHistory);
        this.mGraph.collate();
        this.mTable = new BranchTable(this.mGraph);
        this.mTable.collate();
    }

    public String getImageContentType() {
        return "image/png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderImage(OutputStream out) throws IOException {
        try {
            DrawContextMetrics metrics = new DrawContextMetrics();
            HistoryRenderer renderer = new HistoryRenderer(this.mHistory, this.mGraph, this.mTable, metrics);
            Dimension size = renderer.computeBounds();
            if (size.getHeight() <= 0.0 || size.getWidth() <= 0.0) {
                Logs.APP_LOG.warn((Object)("Can not render Revision History Graph with dimensions: " + size + ", for path: " + this.mHistory.getPath()));
                return false;
            }
            BufferedImage img = new BufferedImage(size.width, size.height, 1);
            Graphics2D g2 = img.createGraphics();
            try {
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.addRenderingHints(hints);
                DrawContext ctx = new DrawContext(g2, metrics);
                renderer.draw(ctx);
            }
            finally {
                g2.dispose();
            }
            ImageIO.write((RenderedImage)img, "PNG", out);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            Logs.APP_LOG.warn((Object)"Problem rendering graph", e3);
            return false;
        }
        return true;
    }

    public String getImageMap() {
        try {
            DrawContextMetrics metrics = new DrawContextMetrics();
            HistoryRenderer renderer = new HistoryRenderer(this.mHistory, this.mGraph, this.mTable, metrics);
            DrawContext ctx = new DrawContext(null, metrics);
            renderer.draw(ctx);
            return ctx.getImageMap();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"Problem rendering graph", e2);
            return "";
        }
    }
}

