/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.ChartDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.ui.RectangleInsets;

public class LocChartParams {
    private ChartDimension size;
    private int maxBarWidth = 5;
    private boolean showVolumeChart = true;
    private boolean showLegend = false;
    private double intraChartGap = 10.0;
    private boolean domainAxisVisible = true;
    private boolean rangeAxisVisible = true;
    private boolean rangeGridlinesVisible = true;
    private boolean domainGridlinesVisible = false;
    private boolean domainAxisLineVisible = true;
    private boolean domainAxisTickMarksVisible = true;
    private boolean domainAxisTickLabelsVisible = true;
    private boolean rangeAxisTickLabelsVisible = true;
    private AxisLocation axisLocation = AxisLocation.BOTTOM_OR_RIGHT;
    private Stroke baseStroke = new BasicStroke(1.0f, 1, 1);
    private RectangleInsets padding = new RectangleInsets(1.0, 1.0, 1.0, 15.0);
    private int numTicksRevcount = 4;
    private int numTicksLinecount = 6;
    private Paint backgroundColor = Color.white;
    private XYURLGenerator urlGenerator;
    private TimeZone timezone;
    private String YAxisType;

    public LocChartParams() {
    }

    public LocChartParams(ChartDimension size, int maxBarWidth) {
        this.size = size;
        this.maxBarWidth = maxBarWidth;
    }

    public static LocChartParams createSparklineParams(ChartDimension chartDimension, int i2) {
        LocChartParams params = new LocChartParams(chartDimension, i2);
        params.setShowVolumeChart(false);
        params.setPadding(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        params.setRangeGridlinesVisible(false);
        params.setDomainGridlinesVisible(false);
        params.setDomainAxisVisible(true);
        params.setRangeAxisVisible(true);
        params.setDomainAxisTickLabelsVisible(false);
        params.setRangeAxisTickLabelsVisible(false);
        params.setDomainAxisTickMarksVisible(false);
        return params;
    }

    public static LocChartParams createSidebarParams(ChartDimension chartDimension, int i2) {
        LocChartParams params = new LocChartParams(chartDimension, i2);
        params.setIntraChartGap(8.0);
        params.setDomainAxisLineVisible(false);
        params.setDomainAxisTickMarksVisible(false);
        params.setAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        params.setNumTicksLinecount(3);
        params.setNumTicksRevcount(2);
        return params;
    }

    public ChartDimension getSize() {
        return this.size;
    }

    public int getMaxBarWidth() {
        return this.maxBarWidth;
    }

    public void setMaxBarWidth(int value) {
        this.maxBarWidth = value;
    }

    public boolean showLegend() {
        return this.isShowLegend();
    }

    public boolean showVolumeChart() {
        return this.isShowVolumeChart();
    }

    public double getIntraChartGap() {
        return this.intraChartGap;
    }

    public boolean isDomainAxisVisible() {
        return this.domainAxisVisible;
    }

    public boolean isRangeAxisVisible() {
        return this.rangeAxisVisible;
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public boolean isDomainAxisLineVisible() {
        return this.domainAxisLineVisible;
    }

    public boolean isDomainAxisTickMarksVisible() {
        return this.domainAxisTickMarksVisible;
    }

    public AxisLocation getAxisLocation() {
        return this.axisLocation;
    }

    public boolean isShowVolumeChart() {
        return this.showVolumeChart;
    }

    public void setShowVolumeChart(boolean showVolumeChart) {
        this.showVolumeChart = showVolumeChart;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public void setIntraChartGap(double intraChartGap) {
        this.intraChartGap = intraChartGap;
    }

    public void setDomainAxisVisible(boolean domainAxisVisible) {
        this.domainAxisVisible = domainAxisVisible;
    }

    public void setRangeAxisVisible(boolean rangeAxisVisible) {
        this.rangeAxisVisible = rangeAxisVisible;
    }

    public void setRangeGridlinesVisible(boolean rangeGridlinesVisible) {
        this.rangeGridlinesVisible = rangeGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean domainGridlinesVisible) {
        this.domainGridlinesVisible = domainGridlinesVisible;
    }

    public void setDomainAxisLineVisible(boolean domainAxisLineVisible) {
        this.domainAxisLineVisible = domainAxisLineVisible;
    }

    public void setDomainAxisTickMarksVisible(boolean domainAxisTickMarksVisible) {
        this.domainAxisTickMarksVisible = domainAxisTickMarksVisible;
    }

    public void setAxisLocation(AxisLocation axisLocation) {
        this.axisLocation = axisLocation;
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke baseStroke) {
        this.baseStroke = baseStroke;
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets padding) {
        this.padding = padding;
    }

    public int getNumTicksRevcount() {
        return this.numTicksRevcount;
    }

    public int getNumTicksLinecount() {
        return this.numTicksLinecount;
    }

    public void setNumTicksLinecount(int numTicksLinecount) {
        this.numTicksLinecount = numTicksLinecount;
    }

    public void setNumTicksRevcount(int numTicksRevcount) {
        this.numTicksRevcount = numTicksRevcount;
    }

    public boolean isDomainAxisTickLabelsVisible() {
        return this.domainAxisTickLabelsVisible;
    }

    public void setDomainAxisTickLabelsVisible(boolean domainAxisTickLabelsVisible) {
        this.domainAxisTickLabelsVisible = domainAxisTickLabelsVisible;
    }

    public boolean isRangeAxisTickLabelsVisible() {
        return this.rangeAxisTickLabelsVisible;
    }

    public void setRangeAxisTickLabelsVisible(boolean rangeAxisTickLabelsVisible) {
        this.rangeAxisTickLabelsVisible = rangeAxisTickLabelsVisible;
    }

    public Paint getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Paint backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setDimension(Integer w2, Integer h2) {
        int width = w2 == null ? this.size.width : w2;
        int height = h2 == null ? this.size.height : h2;
        this.size = new ChartDimension(width, height);
    }

    public void setUrlGenerator(XYURLGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void setYAxisType(String YAxisType) {
        this.YAxisType = YAxisType;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public String getYAxisType() {
        return this.YAxisType;
    }

    public XYURLGenerator getUrlGenerator() {
        return this.urlGenerator;
    }
}

