/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.bucket.CalculatedBucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.vis.ChartDimension;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class LineCountChartUtils {
    static final Color GRIDLINES = Color.LIGHT_GRAY;
    static final Color AXIS_LABELS = Color.GRAY;
    private static final Color TOPLINE_DARK = new Color(12, 135, 201);
    private static final Color TOPLINE_LIGHT = new Color(230, 242, 250);
    private static final Color LIGHT_BLUE = new Color(71, 142, 199);
    private static final Color KHAKI = new Color(118, 152, 16);
    private static final Color ORANGE_PIE = new Color(216, 86, 31);
    private static final Color ORANGE_XY = new Color(215, 86, 31);
    private static final Color YELLOW_PIE = new Color(215, 229, 46);
    private static final Color YELLOW_XY = new Color(222, 228, 57);
    private static final Color DARK_BLUE = new Color(12, 67, 131);
    private static final Color GREEN = new Color(95, 190, 65);
    private static final Color LIGHT_ORANGE = new Color(245, 131, 43);
    private static final Color LIGHT_YELLOW = new Color(237, 239, 0);
    private static final Color BRIGHT_BLUE = new Color(12, 135, 201);
    private static final Color DIRTY_RED = new Color(173, 42, 21);
    private static final Color GREEN2 = new Color(174, 191, 71);
    private static final Color[] LINE_COLOURS_PIE = new Color[]{LIGHT_BLUE, KHAKI, ORANGE_PIE, YELLOW_PIE, DARK_BLUE, GREEN, LIGHT_ORANGE, LIGHT_YELLOW, BRIGHT_BLUE, DIRTY_RED};
    private static final Color[] LINE_COLOURS_XY = new Color[]{ORANGE_XY, LIGHT_BLUE, KHAKI, YELLOW_XY, GREEN, DARK_BLUE, LIGHT_ORANGE, LIGHT_YELLOW, BRIGHT_BLUE, DIRTY_RED, GREEN2};
    private static final Color[] REPOSITORY_COLOURS = new Color[]{ORANGE_XY, KHAKI, YELLOW_XY, GREEN, DARK_BLUE, LIGHT_ORANGE, LIGHT_YELLOW, BRIGHT_BLUE, DIRTY_RED, GREEN2};

    public static String getImageContentType() {
        return "image/png";
    }

    public static Color getXYColour(int i2) {
        return LINE_COLOURS_XY[i2 % LINE_COLOURS_XY.length];
    }

    static Color getToplineColourDark() {
        return TOPLINE_DARK;
    }

    static Color getToplineColourLight() {
        return TOPLINE_LIGHT;
    }

    static Color getPieColour(int i2) {
        return LINE_COLOURS_PIE[i2 % LINE_COLOURS_PIE.length];
    }

    static BufferedImage renderAndWriteChart(JFreeChart chart, CalculatedBucketGraph graphs, OutputStream out, ChartDimension d2) throws IOException {
        BufferedImage image = LineCountChartUtils.renderChart(chart, graphs, d2);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
        return image;
    }

    static BufferedImage renderChart(JFreeChart chart, CalculatedBucketGraph graphs, ChartDimension d2) {
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage image = chart.createBufferedImage(ChartDimension.restrictDimension(d2.getWidth()), ChartDimension.restrictDimension(d2.getHeight()), info);
        graphs.setChartRenderingInfo(info);
        return image;
    }

    public static String getBranchTitle(ParameterSetQuery params) {
        if (params.isTrunkLike()) {
            return null;
        }
        return "Branch " + params.getBranch();
    }

    public static String getAuthorTitle(ParameterSetQuery params) {
        if (params.isAllAuthors()) {
            return null;
        }
        Object[] authors = params.getAuthors();
        if (authors.length == 1) {
            return "Author " + (String)authors[0];
        }
        return "Authors " + Arrays.toString(authors);
    }

    public static String getExtnTitle(ParameterSetQuery params) {
        if (params.isAllExtensions()) {
            return null;
        }
        Object[] extensions = params.getExtensions();
        if (extensions.length == 1) {
            return "File Extension " + (String)extensions[0];
        }
        return "File Extensions " + Arrays.toString(extensions);
    }

    public static String getTitle(ParameterSetQuery params) {
        StringBuilder title = new StringBuilder();
        LineCountChartUtils.appendTitleElement(title, LineCountChartUtils.getBranchTitle(params));
        LineCountChartUtils.appendTitleElement(title, LineCountChartUtils.getAuthorTitle(params));
        LineCountChartUtils.appendTitleElement(title, LineCountChartUtils.getExtnTitle(params));
        return title.toString();
    }

    public static void appendTitleElement(StringBuilder title, String element) {
        if (element != null) {
            if (title.length() != 0) {
                title.append(", ");
            }
            title.append(element);
        }
    }

    public static Color getColourForRep(String repname) {
        List<RepositoryHandle> reps = AppConfig.getsConfig().getRepositoryManager().getHandles();
        int index = reps.size();
        ListIterator<RepositoryHandle> it = reps.listIterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(repname)) continue;
            index = it.previousIndex();
            break;
        }
        return REPOSITORY_COLOURS[index % REPOSITORY_COLOURS.length];
    }
}

