/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LocChartParams;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class LineCountChartLine
extends LineCountChart {
    @Override
    boolean useToplineRenderer(int seriesCount) {
        return false;
    }

    AbstractXYDataset convertData(XYSeriesCollection lineHistory) {
        return lineHistory;
    }

    @Override
    XYPlot createLineCountPlot(CalculatedBucketGraphXY lineHistory, LocChartParams params, DateAxis domainAxis, ColourScheme colourScheme) {
        XYSeriesCollection data = new XYSeriesCollection();
        XYLineAndShapeRenderer lcRenderer = new XYLineAndShapeRenderer(true, false);
        int seriesCollection = 0;
        int series = 0;
        for (Object2ObjectMap.Entry e2 : lineHistory.getChartDataCollection().object2ObjectEntrySet()) {
            Color colour = colourScheme.getLineColour(seriesCollection, (Comparable)e2.getKey());
            for (CalculatedBucketGraphXY.ChartDataSubBranch e22 : ((CalculatedBucketGraphXY.ChartData)e2.getValue()).getSubBranchDataCollection().values()) {
                data.addSeries(e22.getLinecountData());
                lcRenderer.setSeriesPaint(series, (Paint)colour);
                lcRenderer.setSeriesOutlinePaint(series, (Paint)colour);
                ++series;
            }
            ++seriesCollection;
        }
        lcRenderer.setLegendLine((Shape)new Rectangle(20, 20));
        lcRenderer.setBaseSeriesVisibleInLegend(false);
        lcRenderer.setBaseStroke(params.getBaseStroke());
        NumberAxis rangeAxis = this.createValueAxis(params);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)lcRenderer);
        this.setTickUnit(rangeAxis, params.getNumTicksLinecount());
        return plot;
    }

    @Override
    AbstractXYItemRenderer getCommitCountPlotRenderer(int seriesCount, boolean visibleInLegend, ColourScheme colourScheme, XYDataset commitHistory) {
        StackedXYBarRenderer volRenderer = new StackedXYBarRenderer();
        volRenderer.setMargin(0.0);
        volRenderer.setBaseSeriesVisibleInLegend(visibleInLegend);
        volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            volRenderer.setSeriesPaint(i2, (Paint)colourScheme.getBarColour(i2, commitHistory.getSeriesKey(i2)));
        }
        return volRenderer;
    }
}

