/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fecru.charts.StackedXYAreaRenderer2TopLine;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.LocChartParams;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class LineCountChartArea
extends LineCountChart {
    @Override
    boolean useToplineRenderer(int seriesCount) {
        return seriesCount < 2;
    }

    AbstractXYDataset convertData(XYSeriesCollection lineHistory) {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        for (int i2 = 0; i2 < lineHistory.getSeriesCount(); ++i2) {
            dataset.addSeries(lineHistory.getSeries(i2));
        }
        return dataset;
    }

    @Override
    XYPlot createLineCountPlot(CalculatedBucketGraphXY lineHistory, LocChartParams params, DateAxis domainAxis, ColourScheme colourScheme) {
        AbstractXYDataset data = this.convertData(lineHistory.getLinecountCollection());
        AbstractXYItemRenderer renderer = this.getLineCountPlotRenderer(lineHistory.getSeriesCount(), params, colourScheme, data);
        NumberAxis rangeAxis = this.createValueAxis(params);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        this.setTickUnit(rangeAxis, params.getNumTicksLinecount());
        return plot;
    }

    AbstractXYItemRenderer getLineCountPlotRenderer(int seriesCount, LocChartParams locParams, ColourScheme colourScheme, AbstractXYDataset data) {
        int outlineWidth;
        StackedXYAreaRenderer2TopLine renderer;
        if (this.useToplineRenderer(seriesCount)) {
            renderer = new StackedXYAreaRenderer2TopLine();
            renderer.setBaseSeriesVisibleInLegend(true);
            outlineWidth = 2;
        } else {
            renderer = new StackedXYAreaRenderer2();
            renderer.setBaseSeriesVisibleInLegend(false);
            outlineWidth = 1;
        }
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            renderer.setSeriesPaint(i2, (Paint)colourScheme.getAreaColour(i2, data.getSeriesKey(i2)));
            renderer.setSeriesOutlinePaint(i2, (Paint)colourScheme.getAreaOutlineColour(i2, data.getSeriesKey(i2)));
            renderer.setSeriesOutlineStroke(i2, (Stroke)new BasicStroke(outlineWidth, 1, 0));
        }
        renderer.setLegendArea((Shape)new Rectangle(-10, -10, 20, 20));
        return renderer;
    }

    StackedXYBarRenderer getCommitCountPlotRenderer(int seriesCount, boolean visibleInLegend, ColourScheme colourScheme, XYDataset commitHistory) {
        StackedXYBarRenderer volRenderer = new StackedXYBarRenderer();
        volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
        volRenderer.setMargin(0.0);
        if (this.useToplineRenderer(seriesCount)) {
            volRenderer.setSeriesPaint(0, (Paint)LineCountChartUtils.getToplineColourDark());
            volRenderer.setBaseSeriesVisibleInLegend(false);
        } else {
            volRenderer.setBaseSeriesVisibleInLegend(visibleInLegend);
            for (int i2 = 0; i2 < seriesCount; ++i2) {
                volRenderer.setSeriesPaint(i2, (Paint)colourScheme.getBarColour(i2, commitHistory.getSeriesKey(i2)));
            }
        }
        return volRenderer;
    }
}

