/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.cenqua.fisheye.vis.ChartDimension;
import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.ImageMapUtils;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.LocChartParams;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.VerticalAlignment;

public abstract class LineCountChart {
    private Marker marker = null;
    private final TickUnitSource TICK_UNITS = this.createEngineeringTickUnits();

    abstract AbstractXYItemRenderer getCommitCountPlotRenderer(int var1, boolean var2, ColourScheme var3, XYDataset var4);

    abstract boolean useToplineRenderer(int var1);

    abstract XYPlot createLineCountPlot(CalculatedBucketGraphXY var1, LocChartParams var2, DateAxis var3, ColourScheme var4);

    XYPlot createCommitHistoryPlot(XYDataset commitHistory, LocChartParams params, boolean visibleInLegend, DateAxis domainAxis, ColourScheme colourScheme) {
        AbstractXYItemRenderer volRenderer = this.getCommitCountPlotRenderer(commitHistory.getSeriesCount(), visibleInLegend, colourScheme, commitHistory);
        NumberAxis rangeAxis = this.createValueAxis(params);
        XYPlot plot = new XYPlot(commitHistory, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)volRenderer);
        this.setTickUnit(rangeAxis, params.getNumTicksRevcount());
        return plot;
    }

    void setTickUnit(NumberAxis rangeAxis, int numTicks) {
        FreeEngineeringTickUnitSource source = new FreeEngineeringTickUnitSource();
        rangeAxis.setAutoTickUnitSelection(false);
        rangeAxis.setStandardTickUnits((TickUnitSource)source);
        double d2 = (rangeAxis.getUpperBound() - rangeAxis.getLowerBound()) / (double)numTicks;
        double base = Math.pow(10.0, Math.floor(Math.log10(d2)));
        double result = base * (double)Math.round(d2 / base);
        result = Math.max(result, 1.0);
        rangeAxis.setTickUnit((NumberTickUnit)new EngineeringNumberTickUnit(result));
    }

    public BufferedImage renderPathHistoryImage(CalculatedBucketGraphXY graphs, LocChartParams params, ColourScheme colourScheme) {
        if (graphs.noGraphData()) {
            return new BufferedImage(ChartDimension.restrictDimension(params.getSize().getWidth()), ChartDimension.restrictDimension(params.getSize().getHeight()), 2);
        }
        JFreeChart chart = this.createLineCommitHistoryChart(graphs, params, colourScheme);
        return LineCountChartUtils.renderChart(chart, graphs, params.getSize());
    }

    JFreeChart createLineCommitHistoryChart(CalculatedBucketGraphXY graphs, LocChartParams params, ColourScheme colourScheme) {
        JFreeChart chart;
        DateAxis domainAxis = this.createDateAxis(graphs, params);
        XYPlot lcPlot = this.createLineCountPlot(graphs, params, domainAxis, colourScheme);
        this.applyLinecountChartStyle(lcPlot, params, graphs);
        if (params.showVolumeChart()) {
            XYPlot volPlot = this.createCommitHistoryPlot((XYDataset)graphs.getRevcountForStack(), params, true, domainAxis, colourScheme);
            this.applyVolPlotStyle(volPlot, params, graphs);
            chart = this.createComboChart(lcPlot, volPlot, params, domainAxis);
        } else {
            chart = new JFreeChart((Plot)lcPlot);
        }
        this.applyChartStyle(chart, graphs, params);
        return chart;
    }

    private void applyLinecountChartStyle(XYPlot plot, LocChartParams params, CalculatedBucketGraphXY graphs) {
        plot.getRenderer().setBaseToolTipGenerator(ImageMapUtils.getXYToolTipGeneratorLinecount(graphs));
        this.applyPlotStyle(plot, params, graphs);
    }

    private void applyVolPlotStyle(XYPlot plot, LocChartParams params, CalculatedBucketGraphXY graphs) {
        plot.getRenderer().setBaseToolTipGenerator(ImageMapUtils.getXYToolTipGeneratorRevcount(graphs));
        this.applyPlotStyle(plot, params, graphs);
    }

    private void applyPlotStyle(XYPlot plot, LocChartParams params, CalculatedBucketGraphXY graphs) {
        plot.getRenderer().setURLGenerator(params.getUrlGenerator());
        plot.setRangeZeroBaselineVisible(true);
        plot.setRangeGridlinesVisible(params.isRangeGridlinesVisible());
        plot.setDomainGridlinesVisible(params.isDomainGridlinesVisible());
        plot.setForegroundAlpha(1.0f);
        plot.setBackgroundPaint(params.getBackgroundColor());
        plot.setOutlineVisible(false);
        plot.setRangeGridlinePaint((Paint)LineCountChartUtils.GRIDLINES);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 2, 2, 1.0f, new float[]{0.5f, 0.5f}, 0.5f));
        plot.setRangeAxisLocation(params.getAxisLocation());
        plot.setDomainAxisLocation(params.getAxisLocation());
        if (this.marker != null) {
            plot.addDomainMarker(this.marker, Layer.FOREGROUND);
        }
    }

    private void applyChartStyle(JFreeChart chart, CalculatedBucketGraphXY graphs, LocChartParams params) {
        chart.setPadding(params.getPadding());
        chart.setBackgroundPaint(params.getBackgroundColor());
        if (graphs.isShowLegend() && params.showLegend()) {
            chart.getLegend().setPosition(RectangleEdge.BOTTOM);
            chart.getLegend().setVerticalAlignment(VerticalAlignment.CENTER);
            chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            chart.getLegend().setMargin(15.0, 0.0, 0.0, 0.0);
        } else {
            chart.removeLegend();
        }
    }

    JFreeChart createComboChart(XYPlot lcPlot, XYPlot volPlot, LocChartParams params, DateAxis domainAxis) {
        CombinedDomainXYPlot comboPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        comboPlot.setGap(params.getIntraChartGap());
        comboPlot.add(lcPlot, 3);
        comboPlot.add(volPlot, 1);
        comboPlot.setOrientation(PlotOrientation.VERTICAL);
        return new JFreeChart((Plot)comboPlot);
    }

    boolean isVisibleInLegend(CalculatedBucketGraphXY graphs, LocChartParams params) {
        return params.showLegend() && graphs.isShowLegend();
    }

    NumberAxis createValueAxis(LocChartParams params) {
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setVisible(params.isRangeAxisVisible());
        rangeAxis.setTickMarksVisible(false);
        rangeAxis.setTickLabelPaint((Paint)LineCountChartUtils.AXIS_LABELS);
        rangeAxis.setAxisLineVisible(false);
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeMinimumSize(2.0, true);
        rangeAxis.setAutoRangeIncludesZero(params.getYAxisType() == null || !params.getYAxisType().equalsIgnoreCase("tight"));
        rangeAxis.setTickLabelsVisible(params.isRangeAxisTickLabelsVisible());
        return rangeAxis;
    }

    private TickUnitSource createEngineeringTickUnits() {
        double i2;
        TickUnits units = new TickUnits();
        for (i2 = 1.0; i2 < Double.MAX_VALUE; i2 *= 10.0) {
            units.add((TickUnit)new EngineeringNumberTickUnit(i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(2.0 * i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(5.0 * i2));
        }
        for (i2 = -1.0; i2 > Double.MIN_VALUE; i2 *= 10.0) {
            units.add((TickUnit)new EngineeringNumberTickUnit(i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(2.0 * i2));
            units.add((TickUnit)new EngineeringNumberTickUnit(5.0 * i2));
        }
        return units;
    }

    TickUnitSource getEngineeringTickUnits(double maxValue, int numTicks) {
        TickUnits units = new TickUnits();
        double baseValue = maxValue / (double)numTicks;
        this.createEngineeringTickUnits().getCeilingTickUnit(baseValue);
        for (int i2 = 0; i2 < numTicks; ++i2) {
            units.add(this.TICK_UNITS.getCeilingTickUnit(baseValue * (double)(i2 + 1)));
        }
        return units;
    }

    DateAxis createDateAxis(CalculatedBucketGraphXY graph, LocChartParams params) {
        DateAxis domainAxis = new DateAxis();
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        domainAxis.setAutoRange(false);
        domainAxis.setAutoTickUnitSelection(true);
        domainAxis.setTickUnit(new DateTickUnit(2, 4), true, false);
        domainAxis.setTickLabelPaint((Paint)LineCountChartUtils.AXIS_LABELS);
        domainAxis.setTimeZone(params.getTimezone());
        domainAxis.setMinimumDate(graph.getChartMinDate());
        domainAxis.setMaximumDate(graph.getChartMaxDate());
        domainAxis.setAxisLineVisible(params.isDomainAxisLineVisible());
        domainAxis.setTickMarksVisible(params.isDomainAxisTickMarksVisible());
        domainAxis.setVisible(params.isDomainAxisVisible());
        domainAxis.setTickLabelsVisible(params.isDomainAxisTickLabelsVisible());
        return domainAxis;
    }

    public void addDateRangeMarker(long d1, long d2, Color colour) {
        this.marker = new IntervalMarker((double)d1, (double)d2, (Paint)colour, (Stroke)new BasicStroke(1.0f), (Paint)colour, (Stroke)new BasicStroke(1.0f), 1.0f);
    }

    public static class FreeEngineeringTickUnitSource
    implements TickUnitSource {
        private static final double LOG_10_VALUE = Math.log(10.0);

        public TickUnit getLargerTickUnit(TickUnit unit) {
            double x2 = unit.getSize();
            double log = Math.log(x2) / LOG_10_VALUE;
            double higher = Math.ceil(log);
            return new EngineeringNumberTickUnit(Math.ceil(Math.pow(10.0, higher)));
        }

        public TickUnit getCeilingTickUnit(TickUnit unit) {
            return this.getLargerTickUnit(unit);
        }

        public TickUnit getCeilingTickUnit(double size) {
            double log = Math.log(size) / LOG_10_VALUE;
            double higher = Math.ceil(log);
            return new EngineeringNumberTickUnit(Math.ceil(Math.pow(10.0, higher)));
        }
    }

    public static class EngineeringNumberTickUnit
    extends NumberTickUnit {
        DecimalFormat df = new DecimalFormat("0.###");

        public EngineeringNumberTickUnit(double v2) {
            super(v2);
        }

        public EngineeringNumberTickUnit(double v2, DecimalFormat numberFormat) {
            super(v2);
            this.df = numberFormat;
        }

        public String valueToString(double value) {
            return LargeNumberFormatter.formatValue(this.df, value);
        }
    }
}

