/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.ui.filedecoration.GutterRenderResult;
import com.atlassian.fisheye.ui.filedecoration.LineDecorator;
import com.cenqua.fisheye.logging.Logs;

public class Gutter {
    private final LineDecorator decorator;
    private String currentHtml;
    private String currentStyle;
    private String currentClass;

    public Gutter(LineDecorator decorator) {
        this.decorator = decorator;
    }

    public void setLineno(int lineno) {
        this.currentHtml = "&nbsp;";
        this.currentClass = null;
        this.currentStyle = null;
        try {
            GutterRenderResult info = this.decorator.decorateLine(lineno);
            this.currentHtml = info.getInnerHtml();
            this.currentStyle = info.getStyle();
            this.currentClass = info.getClassList();
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem getting gutter for line " + lineno), (Throwable)e2);
        }
    }

    public String getCurrentHtml() {
        return this.currentHtml;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public String getCurrentClassList() {
        return this.currentClass;
    }

    public int getWidth() {
        return this.decorator.getWidth();
    }
}

