/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Graph {
    private final Set<String> mFullBranchPoints = new HashSet<String>();
    private final FileHistory mHistory;
    private final Set<String> mFullBranchNames = new HashSet<String>();
    private final Set<String> mRootBranches = new HashSet<String>();

    public Graph(FileHistory history) {
        this.mHistory = history;
    }

    public void visitSpudOrder(Visitor v2) {
        this.visitSpudOrder(v2, true);
    }

    public void visitSpudOrder(Visitor v2, boolean branchTopToBottom) {
        HashSet<String> visited = new HashSet<String>();
        this.visitBranchesSpudOrder(this.mRootBranches, v2, branchTopToBottom, visited);
    }

    private void visitBranchesSpudOrder(Collection<String> rootBranches, Visitor v2, boolean branchTopToBottom, Set<String> visited) {
        for (String br : rootBranches) {
            if (this.mHistory.getFirstRevisionOnBranch(br) == null || visited.contains(br)) continue;
            v2.visitingBranch(br);
            visited.add(br);
            List<String> revs = this.getBranch(br);
            if (branchTopToBottom) {
                for (String rev : revs) {
                    this.processRev(v2, branchTopToBottom, visited, rev);
                }
                continue;
            }
            for (int j2 = revs.size() - 1; j2 >= 0; --j2) {
                String rev;
                rev = revs.get(j2);
                this.processRev(v2, branchTopToBottom, visited, rev);
            }
        }
    }

    private void processRev(Visitor v2, boolean branchTopToBottom, Set<String> visited, String rev) {
        List<FileRevision> revs = this.mHistory.getRevisionsForRev(rev);
        for (FileRevision info : revs) {
            List<String> branches = info.getBranchPoints();
            if (branches == null || branches.isEmpty()) continue;
            this.visitBranchesSpudOrder(branches, v2, branchTopToBottom, visited);
        }
    }

    public Collection<String> getBranchNames() {
        return this.mFullBranchNames;
    }

    public List<String> getBranch(String br) {
        List<String> branchRevs = this.mHistory.getRevisions(br);
        Collections.reverse(branchRevs);
        return branchRevs;
    }

    public void collate() {
        for (FileRevision rev : this.mHistory.getRevisions()) {
            String br = rev.getBranch();
            this.mFullBranchNames.add(br);
            AncestorLink link = rev.getAncestorLink();
            if (link == null || !link.isDirect() && !link.isBranchPoint()) {
                this.mRootBranches.add(br);
            }
            for (RevInfoKey ancKey : rev.getAncestors()) {
                String arev = ancKey.getRev();
                boolean arevInHist = this.mHistory.containsRevision(arev);
                if (arev == null || !arevInHist) {
                    this.mRootBranches.add(br);
                }
                if (link == null || !link.isBranchPoint() || arev == null || !arevInHist) continue;
                this.mFullBranchPoints.add(arev);
            }
        }
    }

    public boolean isBranchPoint(String rev) {
        return this.mFullBranchPoints.contains(rev);
    }

    public String getBranchOf(String rev) {
        FileRevision info = this.mHistory.getRevision(rev);
        return info.getBranch();
    }

    public String getBranchPoint(String br) {
        return this.mHistory.getBranchPoint(br);
    }

    public static interface Visitor {
        public void visitingBranch(String var1);
    }
}

