/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.FileRevision;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DrawContextMetrics {
    private static final FontMetrics sLabelFontMetrics;
    private static final FontMetrics sDateFontMetrics;
    private static final Font sLabelFont;
    private static final Font sDateFont;
    private static final int sMinColWidth;
    private final int nodeGap = 10;
    private final int nodePad = 3;
    private final int nodeHeight = 30;

    public Font getLabelFont() {
        return sLabelFont;
    }

    public Font getDateFont() {
        return sDateFont;
    }

    public int getRowHeight() {
        return 40;
    }

    public int getColumnGap() {
        return 10;
    }

    public int getNodeHeight() {
        return 30;
    }

    public int getStringWidth(String str) {
        return sLabelFontMetrics.stringWidth(str);
    }

    public int getDateWidth(String str) {
        return sDateFontMetrics.stringWidth(str);
    }

    public int getLabelHeight() {
        return 3 + sLabelFontMetrics.getHeight() + 3;
    }

    public int getRowGap() {
        return 10;
    }

    public int getMinColWidth() {
        return sMinColWidth;
    }

    public int getColumnPad() {
        return 3;
    }

    public int computeWidth(FileRevision ri) {
        String date = this.formatDate(ri.getDate());
        int w2 = this.getStringWidth(ri.getRevision());
        w2 = Math.max(w2, this.getDateWidth(date));
        w2 += this.getColumnPad() * 2;
        w2 = Math.max(w2, this.getMinColWidth());
        return w2;
    }

    public String formatDate(long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd", Locale.US);
        return dateFormat.format(new Date(date));
    }

    static {
        BufferedImage img = new BufferedImage(2, 2, 1);
        Graphics2D g2 = img.createGraphics();
        sLabelFont = g2.getFont();
        sLabelFontMetrics = g2.getFontMetrics(sLabelFont);
        sMinColWidth = sLabelFontMetrics.stringWidth("8.88.8");
        sDateFont = sLabelFont.deriveFont(sLabelFont.getSize2D() * 0.75f);
        sDateFontMetrics = g2.getFontMetrics(sDateFont);
        g2.dispose();
    }
}

