/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class DrawContext {
    private static Color[] INTERIOR_COLOURS = new Color[]{new Color(238, 238, 238), new Color(238, 255, 238), new Color(238, 238, 255), new Color(255, 238, 238)};
    private static Color BRANCH_LABEL_COLOUR = new Color(255, 255, 215);
    private static Color DATE_COLOUR = new Color(96, 96, 96);
    private final Graphics2D g;
    private final DrawContextMetrics metrics;
    private final StringBuffer mMap = new StringBuffer();

    public DrawContext(Graphics2D g2, DrawContextMetrics metrics) {
        this.g = g2;
        this.metrics = metrics;
    }

    public void drawNode(FileHistory hist, FileRevision ri, int x2, int y2, int w2) {
        String revStr = ri.getDisplayRevision();
        int minWidth = this.metrics.computeWidth(ri);
        int indent = Math.max((w2 - minWidth) / 2, 0);
        x2 += indent;
        w2 = minWidth;
        int h2 = this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.fillRect(x2 + 2, y2 + 2, w2, h2);
            this.g.setColor(this.getNodeColour(this.countBranchDepth(hist, ri)));
            this.g.fillRect(x2, y2, w2, h2);
            this.g.setColor(Color.BLACK);
            this.g.drawRect(x2, y2, w2, h2);
            this.g.setColor(Color.BLACK);
            this.drawCenteredString(revStr, x2, y2 + this.metrics.getNodeHeight() / 2, w2, this.metrics.getLabelFont());
            this.g.setColor(DATE_COLOUR);
            int lineOffset = 12;
            this.drawCenteredString(this.metrics.formatDate(ri.getDate()), x2, y2 + this.metrics.getNodeHeight() / 2 + lineOffset, w2, this.metrics.getDateFont());
        }
        this.drawMapRect("#r" + revStr, revStr, x2, y2, w2, h2);
    }

    private int countBranchDepth(FileHistory hist, FileRevision ri) {
        int depth = 0;
        IntOpenHashSet visited = new IntOpenHashSet();
        while (ri != null && !visited.contains(ri.getRevID())) {
            visited.add(ri.getRevID());
            ++depth;
            String br = ri.getBranch();
            String rev = hist.getBranchPoint(br);
            ri = rev == null ? null : hist.getRevision(rev);
        }
        return depth;
    }

    public void drawBranchLabel(String brName, int x2, int y2, int w2) {
        int h2 = this.metrics.getNodeHeight();
        if (this.g != null) {
            int radius = 15;
            this.g.setColor(Color.BLACK);
            this.g.fillRoundRect(x2 + 2, y2 + 2, w2, h2, radius, radius);
            this.g.setColor(BRANCH_LABEL_COLOUR);
            this.g.fillRoundRect(x2, y2, w2, h2, radius, radius);
            this.g.setColor(Color.BLACK);
            this.g.drawRoundRect(x2, y2, w2, h2, radius, radius);
            this.g.setColor(Color.BLACK);
            this.drawCenteredString(brName, x2, y2 + this.metrics.getNodeHeight() / 2, w2, this.metrics.getLabelFont());
        }
        this.drawMapRect("#b" + brName, brName, x2, y2, w2, h2);
    }

    private Color getNodeColour(int depth) {
        int idx = Math.max(0, depth - 1);
        idx = Math.min(idx, INTERIOR_COLOURS.length - 1);
        return INTERIOR_COLOURS[idx];
    }

    public void drawNodeEdge(String r0, int x2, int y0, int w2, String r1, int y1) {
        x2 += w2 / 2;
        y0 += this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.drawLine(x2, y0, x2, y1);
        }
    }

    public void drawSkippedNodeEdge(String r0, int x2, int y0, int w2, String r1, int y1) {
        x2 += w2 / 2;
        y0 += this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.GRAY);
            int len = 3;
            int step = 6;
            for (int y2 = y0; y2 <= y1; y2 += 6) {
                this.g.drawLine(x2, y2, x2, y2 + 3);
            }
        }
    }

    public void drawBranchEdge(String bp, int x0, int y0, int w0, String br, int x1, int y1, int w1) {
        x0 += w0;
        y0 += this.metrics.getNodeHeight() / 2;
        x1 += w1 / 2;
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.drawLine(x0, y0, x1, y0);
            this.g.drawLine(x1, y0, x1, y1);
        }
    }

    public void drawBackground(int width, int height) {
        if (this.g != null) {
            this.g.setColor(Color.WHITE);
            this.g.fillRect(0, 0, width, height);
        }
    }

    private void drawMapRect(String href, String alt, int x2, int y2, int w2, int h2) {
        this.mMap.append("<area href=\"").append(href).append("\"");
        this.mMap.append(" alt=\"").append(alt).append("\"");
        this.mMap.append(" shape=\"rect\"");
        this.mMap.append(" coords=\"");
        this.mMap.append(x2).append(",").append(y2).append(",").append(x2 + w2).append(",").append(y2 + h2);
        this.mMap.append("\">\n");
    }

    private void drawCenteredString(String str, int x2, int y2, int w2, Font font) {
        if (this.g != null) {
            this.g.setFont(font);
            FontMetrics fm = this.g.getFontMetrics(font);
            int xindent = Math.max(0, w2 - fm.stringWidth(str)) / 2;
            this.g.drawString(str, x2 + xindent, y2);
        }
    }

    public String getImageMap() {
        return this.mMap.toString();
    }
}

