/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fisheye.ui.filedecoration.DiffLineDecorator;
import com.atlassian.fisheye.ui.filedecoration.GutterRenderResult;
import com.cenqua.fisheye.logging.Logs;

public class DiffGutter {
    private final DiffLineDecorator decorator;
    private String currentHtml;
    private String currentStyle;
    private String currentClass;

    public static void setGutterLineCommon(DiffGutter gutter, int fromLine, int toLine) {
        gutter.setLineCommon(fromLine, toLine);
    }

    public static void setGutterLineChanged(DiffGutter gutter, int fromLine, int toLine) {
        gutter.setLineChanged(fromLine, toLine);
    }

    public DiffGutter(DiffLineDecorator decorator) {
        this.decorator = decorator;
    }

    public void setLineCommon(int fromLine, int toLine) {
        this.resetDecoration();
        try {
            this.doDecoration(this.decorator.decorateLineCommon(fromLine, toLine));
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem getting gutter for common line " + fromLine), (Throwable)e2);
        }
    }

    public void setLineAdded(int toLine) {
        this.resetDecoration();
        try {
            this.doDecoration(this.decorator.decorateLineAdded(toLine));
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem getting gutter for added line " + toLine), (Throwable)e2);
        }
    }

    public void setLineRemoved(int fromLine) {
        this.resetDecoration();
        try {
            this.doDecoration(this.decorator.decorateLineRemoved(fromLine));
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem getting gutter for removed line " + fromLine), (Throwable)e2);
        }
    }

    public void setLineChanged(int fromLine, int toLine) {
        this.resetDecoration();
        try {
            this.doDecoration(this.decorator.decorateLineChanged(fromLine, toLine));
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem getting gutter for changed line " + fromLine), (Throwable)e2);
        }
    }

    public String getCurrentHtml() {
        return this.currentHtml;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    private void resetDecoration() {
        this.currentHtml = "&nbsp;";
        this.currentClass = null;
        this.currentStyle = null;
    }

    private void doDecoration(GutterRenderResult info) {
        this.currentHtml = info.getInnerHtml();
        this.currentStyle = info.getStyle();
        this.currentClass = info.getClassList();
    }
}

