/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.ColourScheme;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import java.awt.Color;

public class DefaultColourScheme
extends ColourScheme {
    private boolean useSingleColour = false;

    public DefaultColourScheme() {
    }

    public DefaultColourScheme(Color imageBackgroundColour) {
        super(imageBackgroundColour);
    }

    public DefaultColourScheme(int seriesCount, Color imageBackgroundColour) {
        super(imageBackgroundColour);
        this.setNumSeries(seriesCount);
    }

    public DefaultColourScheme(boolean useSingleColour, Color imageBackgroundColour) {
        super(imageBackgroundColour);
        this.useSingleColour = useSingleColour;
    }

    @Override
    public Color getLineColour(int i2, Comparable key) {
        return this.getDarkColour(i2);
    }

    @Override
    public Color getAreaOutlineColour(int i2, Comparable key) {
        return this.getDarkColour(i2);
    }

    @Override
    public Color getBarColour(int i2, Comparable key) {
        return this.getDarkColour(i2);
    }

    @Override
    public Color getAreaColour(int i2, Comparable key) {
        return this.getLightColour(i2);
    }

    private Color defaultColour(int i2) {
        return LineCountChartUtils.getXYColour(i2);
    }

    private Color getDarkColour(int i2) {
        if (this.useSingleColour) {
            return LineCountChartUtils.getToplineColourDark();
        }
        return this.defaultColour(i2);
    }

    private Color getLightColour(int i2) {
        if (this.useSingleColour) {
            return LineCountChartUtils.getToplineColourLight();
        }
        return this.defaultColour(i2);
    }

    @Override
    public void setNumSeries(int numSeries) {
        this.useSingleColour = 1 == numSeries;
    }
}

