/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.crucible.actions.search.ajax.AjaxAutocompleter;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.vis.BaseCommitGraphAction;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CommitGraphBranchFinder
extends BaseCommitGraphAction
implements AjaxAutocompleter<Match> {
    private Pattern pattern;
    private String query;
    private int limit = 10;
    private Boolean sortedByDate = null;
    private List<Match> matches = new ArrayList<Match>();
    private boolean isWorked = true;
    private final Comparator<Match> MATCH_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match o1, Match o2) {
            boolean o2StartsWith;
            boolean o2Exact;
            if (CommitGraphBranchFinder.this.isSortedByDate() && o1.getLastActivity() != null && o2.getLastActivity() != null) {
                if (o1.getLastActivity() == null) {
                    return 1;
                }
                if (o2.getLastActivity() == null) {
                    return -1;
                }
                return -1 * o1.getLastActivity().compareTo(o2.getLastActivity());
            }
            boolean o1Exact = CommitGraphBranchFinder.this.query.equalsIgnoreCase(o1.branchName);
            if (o1Exact ^ (o2Exact = CommitGraphBranchFinder.this.query.equalsIgnoreCase(o2.branchName))) {
                return o1Exact ? -1 : 1;
            }
            boolean o1StartsWith = o1.branchName.startsWith(CommitGraphBranchFinder.this.query);
            if (o1StartsWith ^ (o2StartsWith = o2.branchName.startsWith(CommitGraphBranchFinder.this.query))) {
                return o1StartsWith ? -1 : 1;
            }
            int alphaCompare = o1.branchName.compareToIgnoreCase(o2.branchName);
            if (alphaCompare != 0) {
                return alphaCompare;
            }
            return 0;
        }
    };

    public CommitGraphBranchFinder() {
        super(null, null, null, null);
    }

    @Autowired
    public CommitGraphBranchFinder(RepositoryManager repositoryManager, UserManager userManager, EffectiveUserProvider effectiveUserProvider, RootConfig rootConfig) {
        super(repositoryManager, userManager, effectiveUserProvider, rootConfig);
    }

    @Override
    public void setQ(String query) {
        this.query = query;
        this.pattern = Pattern.compile("\\b" + Pattern.quote(query) + ".*", 2);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public Collection<Match> getMatches() throws Exception {
        SortedList<Match> matches = new SortedList<Match>(this.matches, this.MATCH_COMPARATOR);
        if (this.limit < matches.size()) {
            return matches.subList(0, this.limit);
        }
        return matches;
    }

    @Override
    @RequireSecurityToken(value=false)
    public String execute() {
        String result = super.execute();
        if ("success".equals(result)) {
            Set<Branch> branches = this.getBranches();
            for (Branch branch : branches) {
                if (!this.matches(branch.getName())) continue;
                Date date = null;
                if (this.isSortedByDate()) {
                    date = this.getLastActivityOnBranchDate(branch);
                }
                this.matches.add(new Match(branch.getName(), date));
            }
            this.isWorked = true;
        } else {
            this.isWorked = false;
        }
        return "success";
    }

    public boolean isTruncated() {
        return this.limit < this.matches.size();
    }

    public boolean isSortedByDate() {
        if (this.sortedByDate == null) {
            int branchCount;
            this.sortedByDate = StringUtils.isNotBlank((String)this.query) ? Boolean.valueOf(false) : Boolean.valueOf((branchCount = this.getBranches().size()) <= FishEyeSysProps.RECENTLY_ACTIVE_BRANCH_CHECK_LIMIT);
        }
        return this.sortedByDate;
    }

    private Set<Branch> getBranches() {
        return Sets.filter(this.getRevisionCache().getBranches(), Branch.NOT_REMOVED);
    }

    private Date getLastActivityOnBranchDate(Branch branch) {
        if (branch != null && StringUtils.isNotBlank((String)branch.getLatestChangeSetId())) {
            Object changeSet = this.getRevisionCache().getChangeSet(branch.getLatestChangeSetId());
            return changeSet.getDateValue();
        }
        return null;
    }

    private boolean matches(String s2) {
        return this.pattern.matcher(s2).find();
    }

    @Override
    public String getErrorMsg() {
        return "Could not load branches for repository " + this.getRepositoryName();
    }

    @Override
    public boolean isWorked() {
        return this.isWorked;
    }

    public String getHeader() {
        return this.isSortedByDate() ? "Recently Active" : null;
    }

    public static class Match {
        private final String branchName;
        private final String id;
        private final Date lastActivity;

        public Match(String branchName, Date lastActivity) {
            this.branchName = branchName;
            this.id = branchName;
            this.lastActivity = lastActivity;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getId() {
            return this.id;
        }

        public Date getLastActivity() {
            return this.lastActivity;
        }
    }
}

