/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.ChartDimension;
import com.cenqua.fisheye.vis.LocChartParams;
import java.awt.BasicStroke;

public enum ChartLocation {
    MAIN{

        @Override
        public LocChartParams getParams() {
            LocChartParams params = new LocChartParams(new ChartDimension(700, 400), 6);
            params.setShowLegend(true);
            params.setBaseStroke(new BasicStroke(3.0f, 1, 1));
            return params;
        }
    }
    ,
    PREVIEW{

        @Override
        public LocChartParams getParams() {
            LocChartParams params = new LocChartParams(new ChartDimension(700, 400), 2);
            params.setRangeGridlinesVisible(false);
            params.setDomainGridlinesVisible(false);
            params.setDomainAxisVisible(true);
            params.setRangeAxisVisible(true);
            params.setDomainAxisTickLabelsVisible(false);
            params.setRangeAxisTickLabelsVisible(false);
            return params;
        }
    }
    ,
    SIDEBAR{

        @Override
        public LocChartParams getParams() {
            return LocChartParams.createSidebarParams(new ChartDimension(280, 130), 5);
        }
    }
    ,
    USER{

        @Override
        public LocChartParams getParams() {
            return LocChartParams.createSidebarParams(new ChartDimension(280, 130), 5);
        }
    }
    ,
    SPARKLINE{

        @Override
        public LocChartParams getParams() {
            return LocChartParams.createSparklineParams(new ChartDimension(100, 100), 5);
        }
    }
    ,
    SPARKLINE_USER{

        @Override
        public LocChartParams getParams() {
            return LocChartParams.createSparklineParams(new ChartDimension(100, 100), 5);
        }
    }
    ,
    PROJECT{

        @Override
        public LocChartParams getParams() {
            return new LocChartParams(new ChartDimension(100, 100), 5);
        }
    }
    ,
    SPARKLINE_PROJECT{

        @Override
        public LocChartParams getParams() {
            return LocChartParams.createSparklineParams(new ChartDimension(100, 100), 5);
        }
    };


    public abstract LocChartParams getParams();
}

