/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseCommitGraphAction
extends ActionSupport
implements ServletRequestAware {
    private static final String REPOSITORY_NOT_RUNNING = "repoNotRunning";
    private static final String REPOSITORY_NOT_SUPPORTED = "repoNotSupported";
    private static final String REPOSITORY_NOT_FOUND = "404";
    private static final String PERMISSION_DENIED = "403";
    private static final String LOGIN = "login";
    private final RootConfig rootConfig;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private String repoName;
    private RepositoryHandle repositoryHandle;
    private Path path = Path.ROOT;
    private Path fullPath;
    private HttpServletRequest request;
    private RevisionCache revisionCache;

    @Autowired
    public BaseCommitGraphAction(RepositoryManager repositoryManager, UserManager userManager, EffectiveUserProvider effectiveUserProvider, RootConfig rootConfig) {
        this.repositoryManager = repositoryManager;
        this.userManager = userManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.rootConfig = rootConfig;
    }

    public String execute() {
        if (this.rootConfig.isCrucibleOnly()) {
            return REPOSITORY_NOT_FOUND;
        }
        this.fullPath = new Path(this.getRepositoryName(), this.getPath());
        this.repositoryHandle = this.repositoryManager.getRepository(this.getRepositoryName());
        if (this.repositoryHandle == null) {
            return REPOSITORY_NOT_FOUND;
        }
        this.request.setAttribute("repoName", (Object)this.getRepositoryName());
        this.request.setAttribute("isPipelined", (Object)this.repositoryHandle.isPipelined());
        if (this.repositoryHandle.getCfg().getRepositoryType() == ScmType.CLEARCASE) {
            this.request.setAttribute("scmType", (Object)this.repositoryHandle.getCfg().getRepositoryType().fullName);
            return REPOSITORY_NOT_SUPPORTED;
        }
        try {
            this.revisionCache = this.repositoryHandle.acquireEngine().getRevisionCache();
        }
        catch (RepositoryHandle.StateException e2) {
            this.request.setAttribute("state", (Object)this.repositoryHandle.getStateDescription());
            String msg = this.repositoryHandle.getStatus().getMessage();
            if (!Strings.isNullOrEmpty((String)msg)) {
                this.request.setAttribute("status", (Object)msg);
            }
            Logs.APP_LOG.error((Object)("Repository " + this.repositoryHandle.getName() + " is not running"), (Throwable)((Object)e2));
            return REPOSITORY_NOT_RUNNING;
        }
        UserLogin user = this.effectiveUserProvider.getEffectiveUserLogin();
        if (!this.userManager.hasPermissionToAccess(user, this.repositoryHandle)) {
            if (user == null) {
                return LOGIN;
            }
            return PERMISSION_DENIED;
        }
        return "success";
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public RepositoryHandle getRepositoryHandle() {
        if (this.repositoryHandle == null) {
            this.repositoryHandle = this.repositoryManager.getRepository(this.repoName);
        }
        return this.repositoryHandle;
    }

    public String getRepositoryName() {
        return this.repositoryHandle != null ? this.repositoryHandle.getName() : this.repoName;
    }

    protected RevisionCache getRevisionCache() {
        return this.revisionCache;
    }

    public Path getFullPath() {
        return this.fullPath;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = new Path(path);
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

