/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import com.cenqua.fisheye.util.diff.SectionSpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnifiedDiffSectionSpec
implements SectionSpec {
    public static final String SECTION_CORE_REGEX = " *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *";
    public static final String STANDARD_DELIMITER = "@@";
    public static final String STANDARD_SECTION_REGEX = "@@ *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *@@";
    private static final Pattern SECTION_PATTERN = Pattern.compile(" *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *");
    private int from;
    private int fromCount;
    private int to;
    private int toCount;

    public UnifiedDiffSectionSpec(String sectionLine) {
        this(STANDARD_DELIMITER, sectionLine);
    }

    public UnifiedDiffSectionSpec(String delimiter, String sectionLine) {
        Matcher matcher = UnifiedDiffSectionSpec.getSectionMatcher(delimiter, sectionLine);
        if (matcher == null || !matcher.matches()) {
            throw new IllegalArgumentException("Section line [" + sectionLine + "] is not a valid diff section line");
        }
        String fromStr = matcher.group(1);
        String fromCountStr = matcher.group(3);
        String toStr = matcher.group(5);
        String toCountStr = matcher.group(7);
        this.from = Integer.parseInt(fromStr);
        this.fromCount = fromCountStr != null ? Integer.parseInt(fromCountStr) : 1;
        if (toStr == null) {
            this.to = -1;
            this.toCount = -1;
        } else {
            this.to = Integer.parseInt(toStr);
            this.toCount = toCountStr != null ? Integer.parseInt(toCountStr) : 1;
        }
    }

    @Override
    public int getFrom() {
        return this.from;
    }

    @Override
    public int getFromCount() {
        return this.fromCount;
    }

    @Override
    public int getTo() {
        return this.to;
    }

    @Override
    public int getToCount() {
        return this.toCount;
    }

    public static boolean isValidSection(String sectionLine) {
        return UnifiedDiffSectionSpec.isValidSection(STANDARD_DELIMITER, sectionLine);
    }

    public static boolean isValidSection(String delimiter, String sectionLine) {
        Matcher matcher = UnifiedDiffSectionSpec.getSectionMatcher(delimiter, sectionLine);
        return matcher != null && matcher.matches();
    }

    private static Matcher getSectionMatcher(String delimiter, String sectionLine) {
        String line = sectionLine.trim();
        if (!line.startsWith(delimiter) || !line.endsWith(delimiter) || line.length() <= 2 * delimiter.length()) {
            return null;
        }
        line = line.substring(delimiter.length(), line.length() - delimiter.length());
        return SECTION_PATTERN.matcher(line);
    }
}

