/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.util.diff.SectionSpec;

public abstract class HunkFactory {
    private int currentFromLine;
    private int currentToLine;
    private int hunkFrom = -1;
    private int hunkFromLength;
    private int hunkTo;
    private int hunkToLength;
    private SectionSpec section;
    private int sectionToLength;
    private int sectionFromLength;

    public void startSection(SectionSpec section) {
        this.section = section;
        this.currentFromLine = section.getFrom();
        this.currentToLine = section.getTo();
        this.sectionToLength = 0;
        this.sectionFromLength = 0;
    }

    public void endSection() {
        this.addCurrentHunk();
        this.section = null;
    }

    public void addLine() {
        if (this.hunkFrom == -1) {
            this.newHunk();
        }
        ++this.hunkToLength;
        ++this.currentToLine;
        ++this.sectionToLength;
    }

    public void removeLine() {
        if (this.hunkFrom == -1) {
            this.newHunk();
        }
        ++this.hunkFromLength;
        ++this.currentFromLine;
        ++this.sectionFromLength;
    }

    private void newHunk() {
        this.hunkFrom = this.currentFromLine;
        this.hunkFromLength = 0;
        this.hunkTo = this.currentToLine;
        this.hunkToLength = 0;
    }

    public void contextLine() {
        this.addCurrentHunk();
        ++this.currentFromLine;
        ++this.currentToLine;
        ++this.sectionFromLength;
        ++this.sectionToLength;
    }

    private void addCurrentHunk() {
        if (this.hunkFrom != -1) {
            if (this.hunkFromLength == 0 && this.hunkFrom != 0) {
                --this.hunkFrom;
            }
            if (this.hunkToLength == 0 && this.hunkTo != 0) {
                --this.hunkTo;
            }
            Hunk hunk = new Hunk(this.hunkFrom, this.hunkTo, this.hunkFromLength, this.hunkToLength);
            this.addHunk(hunk);
            this.hunkFrom = -1;
        }
    }

    public abstract void addHunk(Hunk var1);

    public SectionSpec getSection() {
        return this.section;
    }

    public boolean isSectionFinished() {
        return this.sectionFromLength == this.section.getFromCount() && this.sectionToLength == this.section.getToCount() || this.sectionFromLength > this.section.getFromCount() || this.sectionToLength > this.section.getToCount();
    }
}

