/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.LineDO;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DiffBlameUtil {
    public static final int URL_MAX_LENGTH = 2000;
    private static final BiFunction<Integer, Integer, String> asParameter = (start, end) -> "f=" + (start + 1) + "-" + (end - start + 1);
    private static final Logger LOG = Logs.loggerFor(DiffBlameUtil.class);

    public static String generateBlameRestUrl(HttpServletRequest request, Source source, FileRevision fileRevision, Iterator<LinePair> linePairIter, boolean generateFrom) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            DiffBlameUtil.appendServiceUrlAndRepository(urlBuilder, request, source.getName());
            DiffBlameUtil.appendPathAndRevision(urlBuilder, fileRevision.getPath().toString(), fileRevision.getRevision());
            DiffBlameUtil.appendBlameFilterIfFits(urlBuilder, DiffBlameUtil.generateBlockFilterForBlameRest(linePairIter, generateFrom));
            return urlBuilder.toString();
        }
        catch (Exception ex) {
            LOG.debug((Object)("Failed to generate blame url for " + fileRevision), (Throwable)ex);
            return null;
        }
    }

    public static String generateBlameRestUrl(@Nullable HttpServletRequest request, @Nonnull Source source, @Nonnull CrucibleRevision crucibleRevision, @Nonnull List<LineDO> sourceLines, boolean generateFrom) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            DiffBlameUtil.appendServiceUrlAndRepository(urlBuilder, request, source.getName());
            DiffBlameUtil.appendPathAndRevision(urlBuilder, crucibleRevision.getPath(), crucibleRevision.getRevision());
            DiffBlameUtil.appendBlameFilterIfFits(urlBuilder, DiffBlameUtil.generateBlockFilterForBlameRest(sourceLines, generateFrom));
            return urlBuilder.toString();
        }
        catch (Exception ex) {
            LOG.debug((Object)("Failed to generate blame url for " + crucibleRevision), (Throwable)ex);
            return null;
        }
    }

    protected static String generateBlockFilterForBlameRest(Iterator<LinePair> linePairIter, boolean generateFrom) {
        if (linePairIter == null) {
            return "";
        }
        ArrayList blocks = Lists.newArrayList();
        Function<LinePair, LinePair.Line> getLine = linePair -> generateFrom ? linePair.getFrom() : linePair.getTo();
        int start = -1;
        int end = -1;
        while (linePairIter.hasNext()) {
            LinePair.Line line;
            LinePair linePair2 = linePairIter.next();
            if (linePair2.isStartOfSection() && linePair2.getSection().isSkippedPrevious()) {
                if (start != -1) {
                    blocks.add(asParameter.apply(start, end));
                }
                start = -1;
            }
            if ((line = getLine.apply(linePair2)) == null) continue;
            if (start == -1) {
                start = line.getLineNumber();
            }
            end = line.getLineNumber();
        }
        if (start != -1) {
            blocks.add(asParameter.apply(start, end));
        }
        return String.join((CharSequence)"&", blocks);
    }

    protected static String generateBlockFilterForBlameRest(List<LineDO> lines, boolean generateFrom) {
        if (lines.isEmpty()) {
            return "";
        }
        Function<LineDO, LinePair.Line> getLine = line -> generateFrom ? line.getLinePair().getFrom() : line.getLinePair().getTo();
        ArrayList blocks = Lists.newArrayList();
        int start = -1;
        int end = -1;
        for (LineDO lineDO : lines) {
            LinePair.Line line2;
            if (lineDO.isSkippedPrevious()) {
                if (start != -1) {
                    blocks.add(asParameter.apply(start, end));
                }
                start = -1;
            }
            if ((line2 = getLine.apply(lineDO)) == null) continue;
            if (start == -1) {
                start = line2.getLineNumber();
            }
            end = line2.getLineNumber();
        }
        if (start != -1) {
            blocks.add(asParameter.apply(start, end));
        }
        return String.join((CharSequence)"&", blocks);
    }

    private static void appendServiceUrlAndRepository(StringBuilder urlBuilder, HttpServletRequest request, String sourceName) {
        urlBuilder.append(NavBuilder.getSiteUrl(request)).append("/rest-service-fecru/blame").append("?rep=").append(FishEyeURLEncoder.uriEncode(sourceName));
    }

    private static void appendPathAndRevision(StringBuilder urlBuilder, String path, String revision) {
        urlBuilder.append("&file=").append(FishEyeURLEncoder.uriEncode(path)).append("&rev=").append(FishEyeURLEncoder.uriEncode(revision));
    }

    private static void appendBlameFilterIfFits(StringBuilder urlBuilder, String sectionFilter) {
        if (!sectionFilter.isEmpty() && sectionFilter.length() + urlBuilder.length() < 2000) {
            urlBuilder.append("&").append(sectionFilter);
        }
    }
}

