/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.cond;

import com.cenqua.fisheye.util.cond.AtomEvaluator;
import com.cenqua.fisheye.util.cond.BoolExpr;
import java.util.ArrayList;
import java.util.List;

public class ShortCutExpr
extends BoolExpr {
    private final boolean allRequired;
    private final List terms = new ArrayList(4);

    public ShortCutExpr(boolean allRequired) {
        this.allRequired = allRequired;
    }

    public void add(BoolExpr term) {
        this.terms.add(term);
    }

    @Override
    public boolean evaluate(AtomEvaluator evaluator) {
        if (this.terms.isEmpty()) {
            return false;
        }
        for (int i2 = 0; i2 < this.terms.size(); ++i2) {
            BoolExpr term = (BoolExpr)this.terms.get(i2);
            boolean val = term.evaluate(evaluator);
            if (this.allRequired) {
                if (val) continue;
                return false;
            }
            if (!val) continue;
            return true;
        }
        return this.allRequired;
    }

    @Override
    BoolExpr simplify() {
        if (this.terms.size() == 1) {
            return ((BoolExpr)this.terms.get(0)).simplify();
        }
        for (int i2 = 0; i2 < this.terms.size(); ++i2) {
            BoolExpr term = (BoolExpr)this.terms.get(i2);
            this.terms.set(i2, term.simplify());
        }
        return this;
    }
}

