/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;

public class SegmentedIntSet
implements SortedIntSet {
    static final int SEGMENT_BITSIZE = 8192;
    static final int SEGMENT_HIMASK = -8192;
    private final Int2ObjectSortedMap<BiDiBitSet> segments = new Int2ObjectAVLTreeMap();

    @Override
    public boolean get(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs == null) {
            return false;
        }
        int idxOffset = idx - segment;
        return bs.get(idxOffset);
    }

    @Override
    public void set(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs == null) {
            bs = new BiDiBitSet(8192);
            this.segments.put(segment, (Object)bs);
        }
        int idxOffset = idx - segment;
        bs.set(idxOffset);
    }

    @Override
    public void clear(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs != null) {
            int idxOffset = idx - segment;
            bs.clear(idxOffset);
        }
    }

    @Override
    public int nextSetBit(int idx) {
        int segment = idx & 0xFFFFE000;
        int idxOffset = idx - segment;
        do {
            int nextOffset;
            BiDiBitSet bs;
            if ((bs = (BiDiBitSet)this.segments.get(segment)) != null && (nextOffset = bs.nextSetBit(idxOffset)) != -1) {
                return nextOffset + segment;
            }
            segment = this.nextSegment(segment);
            idxOffset = 0;
        } while (segment != -1);
        return -1;
    }

    @Override
    public int prevSetBit(int idx) {
        int segment = idx & 0xFFFFE000;
        int idxOffset = idx - segment;
        do {
            int prevOffset;
            BiDiBitSet bs;
            if ((bs = (BiDiBitSet)this.segments.get(segment)) != null && (prevOffset = bs.prevSetBit(idxOffset)) != -1) {
                return prevOffset + segment;
            }
            segment = this.prevSegment(segment);
            idxOffset = 8192;
        } while (segment != -1);
        return -1;
    }

    @Override
    public int length() {
        int segment = this.prevSegment(Integer.MAX_VALUE);
        if (segment == -1) {
            return 0;
        }
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        return bs.length() + segment;
    }

    @Override
    public int cardinality() {
        int count = 0;
        for (BiDiBitSet bs : this.segments.values()) {
            count += bs.cardinality();
        }
        return count;
    }

    private int nextSegment(int segment) {
        ObjectSortedSet tailsegs = this.segments.tailMap(segment + 1).int2ObjectEntrySet();
        if (tailsegs.isEmpty()) {
            return -1;
        }
        return ((Int2ObjectMap.Entry)tailsegs.first()).getIntKey();
    }

    private int prevSegment(int segment) {
        ObjectSortedSet headsegs = this.segments.headMap(segment).int2ObjectEntrySet();
        if (headsegs.isEmpty()) {
            return -1;
        }
        Integer prev = ((Int2ObjectMap.Entry)headsegs.last()).getIntKey();
        return prev;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        buffer.append('{');
        int i2 = this.nextSetBit(0);
        while (i2 >= 0) {
            buffer.append(separator);
            separator = ", ";
            buffer.append(i2);
            i2 = this.nextSetBit(i2 + 1);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

