/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;

public class BitSets {
    public static SortedIntSet newLazyBitSet() {
        return new SegmentedIntSet();
    }

    public static SortedIntSet newLazyBitSet(Iterable<? extends Number> values) {
        return BitSets.set(BitSets.newLazyBitSet(), values);
    }

    public static BiDiBitSet newBitSet() {
        return new BiDiBitSet();
    }

    public static SortedIntSet newBitSet(Iterable<? extends Number> values) {
        return BitSets.set(BitSets.newBitSet(), values);
    }

    public static SortedIntSet set(SortedIntSet bitSet, Iterable<? extends Number> values) {
        for (Number number : values) {
            bitSet.set(number.intValue());
        }
        return bitSet;
    }

    public static SortedIntSet clear(SortedIntSet bitSet, Iterable<? extends Number> values) {
        for (Number number : values) {
            bitSet.clear(number.intValue());
        }
        return bitSet;
    }

    public static Iterable<Integer> ascendingIterable(final SortedIntSet bitSet) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new BitSetNextIterator(bitSet);
            }
        };
    }

    public static Iterable<Integer> descendingIterable(final SortedIntSet bitSet) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new BitSetPreviousIterator(bitSet);
            }
        };
    }

    public static void clear(SortedIntSet bitSet, long from, long to) {
        int i2 = bitSet.nextSetBit((int)from);
        while (i2 >= 0 && (long)i2 <= to) {
            bitSet.clear(i2);
            i2 = bitSet.nextSetBit(i2);
        }
    }

    private static class BitSetPreviousIterator
    extends AbstractBitSetIterator {
        public BitSetPreviousIterator(SortedIntSet bitSet) {
            super(bitSet);
        }

        @Override
        protected int initial() {
            return this.next(this.bitSet.length());
        }

        @Override
        protected int next(int old) {
            return this.bitSet.prevSetBit(old - 1);
        }
    }

    private static class BitSetNextIterator
    extends AbstractBitSetIterator {
        public BitSetNextIterator(SortedIntSet bitSet) {
            super(bitSet);
        }

        @Override
        protected int initial() {
            return this.bitSet.nextSetBit(0);
        }

        @Override
        protected int next(int old) {
            return this.bitSet.nextSetBit(old + 1);
        }
    }

    private static abstract class AbstractBitSetIterator
    extends UnmodifiableIterator<Integer> {
        protected final SortedIntSet bitSet;
        private int currentBit;

        public AbstractBitSetIterator(SortedIntSet bitSet) {
            this.bitSet = bitSet;
            this.currentBit = this.initial();
        }

        public Integer next() {
            int oldBit = this.currentBit;
            this.currentBit = this.next(this.currentBit);
            return oldBit;
        }

        public boolean hasNext() {
            return this.currentBit != -1;
        }

        protected abstract int initial();

        protected abstract int next(int var1);
    }
}

