/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BiDiBitSet
implements SortedIntSet,
Serializable,
Cloneable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static int[] leadingZeroTable = new int[]{-24, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int i2;
        for (i2 = this.unitsInUse - 1; i2 >= 0 && this.bits[i2] == 0L; --i2) {
        }
        this.unitsInUse = i2 + 1;
    }

    public BiDiBitSet() {
        this(64);
    }

    public BiDiBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.bits = new long[BiDiBitSet.unitIndex(nbits - 1) + 1];
    }

    private void ensureCapacity(int unitsRequired) {
        if (this.bits.length < unitsRequired) {
            int request = Math.max(2 * this.bits.length, unitsRequired);
            long[] newBits = new long[request];
            System.arraycopy(this.bits, 0, newBits, 0, this.unitsInUse);
            this.bits = newBits;
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = BiDiBitSet.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n2 = unitIndex;
            this.bits[n2] = this.bits[n2] ^ BiDiBitSet.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n3 = unitIndex;
            this.bits[n3] = this.bits[n3] ^ BiDiBitSet.bit(bitIndex);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
        }
    }

    public void flip(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int endUnitIndex = BiDiBitSet.unitIndex(toIndex);
        int unitsRequired = endUnitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            this.unitsInUse = unitsRequired;
        }
        int startUnitIndex = BiDiBitSet.unitIndex(fromIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n2 = startUnitIndex;
            this.bits[n2] = this.bits[n2] ^ bitMask;
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        bitMask = BiDiBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n3 = startUnitIndex;
        this.bits[n3] = this.bits[n3] ^ bitMask;
        if (endUnitIndex - startUnitIndex > 1) {
            int i2 = startUnitIndex + 1;
            while (i2 < endUnitIndex) {
                int n4 = i2++;
                this.bits[n4] = this.bits[n4] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        bitMask = BiDiBitSet.bitsRightOf(toIndex & 0x3F);
        int n5 = endUnitIndex;
        this.bits[n5] = this.bits[n5] ^ bitMask;
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    private static long bitsRightOf(int x2) {
        return x2 == 0 ? 0L : -1L >>> 64 - x2;
    }

    private static long bitsLeftOf(int x2) {
        return -1L << x2;
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = BiDiBitSet.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n2 = unitIndex;
            this.bits[n2] = this.bits[n2] | BiDiBitSet.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n3 = unitIndex;
            this.bits[n3] = this.bits[n3] | BiDiBitSet.bit(bitIndex);
        }
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int endUnitIndex = BiDiBitSet.unitIndex(toIndex);
        int unitsRequired = endUnitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            this.unitsInUse = unitsRequired;
        }
        int startUnitIndex = BiDiBitSet.unitIndex(fromIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n2 = startUnitIndex;
            this.bits[n2] = this.bits[n2] | bitMask;
            return;
        }
        bitMask = BiDiBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n3 = startUnitIndex;
        this.bits[n3] = this.bits[n3] | bitMask;
        if (endUnitIndex - startUnitIndex > 1) {
            int i2 = startUnitIndex + 1;
            while (i2 < endUnitIndex) {
                int n4 = i2++;
                this.bits[n4] = this.bits[n4] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        bitMask = BiDiBitSet.bitsRightOf(toIndex & 0x3F);
        int n5 = endUnitIndex;
        this.bits[n5] = this.bits[n5] | bitMask;
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int unitIndex = BiDiBitSet.unitIndex(bitIndex);
        if (unitIndex >= this.unitsInUse) {
            return;
        }
        int n2 = unitIndex;
        this.bits[n2] = this.bits[n2] & (BiDiBitSet.bit(bitIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        int startUnitIndex = BiDiBitSet.unitIndex(fromIndex);
        if (startUnitIndex >= this.unitsInUse) {
            return;
        }
        int endUnitIndex = BiDiBitSet.unitIndex(toIndex);
        long bitMask = 0L;
        if (startUnitIndex == endUnitIndex) {
            bitMask = (1L << (toIndex & 0x3F)) - (1L << (fromIndex & 0x3F));
            int n2 = startUnitIndex;
            this.bits[n2] = this.bits[n2] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        bitMask = BiDiBitSet.bitsLeftOf(fromIndex & 0x3F);
        int n3 = startUnitIndex;
        this.bits[n3] = this.bits[n3] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
        if (endUnitIndex - startUnitIndex > 1) {
            for (int i2 = startUnitIndex + 1; i2 < endUnitIndex; ++i2) {
                if (i2 >= this.unitsInUse) continue;
                this.bits[i2] = 0L;
            }
        }
        if (endUnitIndex < this.unitsInUse) {
            bitMask = BiDiBitSet.bitsRightOf(toIndex & 0x3F);
            int n4 = endUnitIndex;
            this.bits[n4] = this.bits[n4] & (bitMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    @Override
    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        boolean result = false;
        int unitIndex = BiDiBitSet.unitIndex(bitIndex);
        if (unitIndex < this.unitsInUse) {
            result = (this.bits[unitIndex] & BiDiBitSet.bit(bitIndex)) != 0L;
        }
        return result;
    }

    public BiDiBitSet get(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (this.length() <= fromIndex || fromIndex == toIndex) {
            return new BiDiBitSet(0);
        }
        if (this.length() < toIndex) {
            toIndex = this.length();
        }
        BiDiBitSet result = new BiDiBitSet(toIndex - fromIndex);
        int startBitIndex = fromIndex & 0x3F;
        int endBitIndex = toIndex & 0x3F;
        int targetWords = (toIndex - fromIndex + 63) / 64;
        int sourceWords = BiDiBitSet.unitIndex(toIndex) - BiDiBitSet.unitIndex(fromIndex) + 1;
        int inverseIndex = 64 - startBitIndex;
        int targetIndex = 0;
        int sourceIndex = BiDiBitSet.unitIndex(fromIndex);
        while (targetIndex < targetWords - 1) {
            result.bits[targetIndex++] = this.bits[sourceIndex++] >>> startBitIndex | (inverseIndex == 64 ? 0L : this.bits[sourceIndex] << inverseIndex);
        }
        result.bits[targetIndex] = sourceWords == targetWords ? (this.bits[sourceIndex] & BiDiBitSet.bitsRightOf(endBitIndex)) >>> startBitIndex : this.bits[sourceIndex++] >>> startBitIndex | (inverseIndex == 64 ? 0L : (this.getBits(sourceIndex) & BiDiBitSet.bitsRightOf(endBitIndex)) << inverseIndex);
        result.unitsInUse = targetWords;
        result.recalculateUnitsInUse();
        return result;
    }

    private long getBits(int j2) {
        return j2 < this.unitsInUse ? this.bits[j2] : 0L;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u2 = BiDiBitSet.unitIndex(fromIndex);
        if (u2 >= this.unitsInUse) {
            return -1;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u2] >> testIndex;
        if (unit == 0L) {
            testIndex = 0;
        }
        while (unit == 0L && u2 < this.unitsInUse - 1) {
            unit = this.bits[++u2];
        }
        if (unit == 0L) {
            return -1;
        }
        return u2 * 64 + (testIndex += BiDiBitSet.trailingZeroCnt(unit));
    }

    @Override
    public int prevSetBit(int fromIndex) {
        int testIndex;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (this.bits.length == 0) {
            return -1;
        }
        int u2 = BiDiBitSet.unitIndex(fromIndex);
        if (u2 != 0 && u2 >= this.unitsInUse) {
            u2 = this.unitsInUse - 1;
            fromIndex = 63;
        }
        long mask = (testIndex = fromIndex & 0x3F) == 63 ? -1L : -1L >> testIndex + 1 << testIndex + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long unit = this.bits[u2];
        unit &= mask;
        while (unit == 0L && u2 > 0) {
            unit = this.bits[--u2];
        }
        if (unit == 0L) {
            return -1;
        }
        testIndex = 63 - BiDiBitSet.unrolledStartingZeroCnt(unit);
        return u2 * 64 + testIndex;
    }

    static int unrolledStartingZeroCnt(long val) {
        int byteVal = (int)(val >>> 56) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal];
        }
        byteVal = (int)(val >> 48) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 8;
        }
        byteVal = (int)(val >> 40) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 16;
        }
        byteVal = (int)(val >> 32) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 24;
        }
        byteVal = (int)(val >> 24) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 32;
        }
        byteVal = (int)(val >> 16) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 40;
        }
        byteVal = (int)(val >> 8) & 0xFF;
        if (byteVal != 0) {
            return leadingZeroTable[byteVal] + 48;
        }
        byteVal = (int)val & 0xFF;
        return leadingZeroTable[byteVal] + 56;
    }

    static int trailingZeroCnt(long val) {
        int byteVal = (int)val & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal];
        }
        byteVal = (int)(val >>> 8) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 8;
        }
        byteVal = (int)(val >>> 16) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 16;
        }
        byteVal = (int)(val >>> 24) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 24;
        }
        byteVal = (int)(val >>> 32) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 32;
        }
        byteVal = (int)(val >>> 40) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 40;
        }
        byteVal = (int)(val >>> 48) & 0xFF;
        if (byteVal != 0) {
            return trailingZeroTable[byteVal] + 48;
        }
        byteVal = (int)(val >>> 56) & 0xFF;
        return trailingZeroTable[byteVal] + 56;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u2 = BiDiBitSet.unitIndex(fromIndex);
        if (u2 >= this.unitsInUse) {
            return fromIndex;
        }
        int testIndex = fromIndex & 0x3F;
        long unit = this.bits[u2] >> testIndex;
        if (unit == -1L >> testIndex) {
            testIndex = 0;
        }
        while (unit == -1L && u2 < this.unitsInUse - 1) {
            unit = this.bits[++u2];
        }
        if (unit == -1L) {
            return this.length();
        }
        if (unit == 0L) {
            return u2 * 64 + testIndex;
        }
        return u2 * 64 + (testIndex += BiDiBitSet.trailingZeroCnt(unit ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long highestUnit = this.bits[this.unitsInUse - 1];
        int highPart = (int)(highestUnit >>> 32);
        return 64 * (this.unitsInUse - 1) + (highPart == 0 ? BiDiBitSet.bitLen((int)highestUnit) : 32 + BiDiBitSet.bitLen(highPart));
    }

    private static int bitLen(int w2) {
        return w2 < 32768 ? (w2 < 128 ? (w2 < 8 ? (w2 < 2 ? (w2 < 1 ? (w2 < 0 ? 32 : 0) : 1) : (w2 < 4 ? 2 : 3)) : (w2 < 32 ? (w2 < 16 ? 4 : 5) : (w2 < 64 ? 6 : 7))) : (w2 < 2048 ? (w2 < 512 ? (w2 < 256 ? 8 : 9) : (w2 < 1024 ? 10 : 11)) : (w2 < 8192 ? (w2 < 4096 ? 12 : 13) : (w2 < 16384 ? 14 : 15)))) : (w2 < 0x800000 ? (w2 < 524288 ? (w2 < 131072 ? (w2 < 65536 ? 16 : 17) : (w2 < 262144 ? 18 : 19)) : (w2 < 0x200000 ? (w2 < 0x100000 ? 20 : 21) : (w2 < 0x400000 ? 22 : 23))) : (w2 < 0x8000000 ? (w2 < 0x2000000 ? (w2 < 0x1000000 ? 24 : 25) : (w2 < 0x4000000 ? 26 : 27)) : (w2 < 0x20000000 ? (w2 < 0x10000000 ? 28 : 29) : (w2 < 0x40000000 ? 30 : 31))));
    }

    private boolean isEmpty() {
        return this.unitsInUse == 0;
    }

    public boolean intersects(BiDiBitSet set) {
        for (int i2 = Math.min(this.unitsInUse, set.unitsInUse) - 1; i2 >= 0; --i2) {
            if ((this.bits[i2] & set.bits[i2]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i2 = 0; i2 < this.unitsInUse; ++i2) {
            sum += BiDiBitSet.bitCount(this.bits[i2]);
        }
        return sum;
    }

    private static int bitCount(long val) {
        val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
        val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
        val += val >>> 8;
        val += val >>> 16;
        return (int)val + (int)(val >>> 32) & 0xFF;
    }

    public void and(BiDiBitSet set) {
        int i2;
        if (this == set) {
            return;
        }
        int oldUnitsInUse = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        for (i2 = 0; i2 < this.unitsInUse; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] & set.bits[i2];
        }
        while (i2 < oldUnitsInUse) {
            this.bits[i2] = 0L;
            ++i2;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(BiDiBitSet set) {
        int i2;
        if (this == set) {
            return;
        }
        this.ensureCapacity(set.unitsInUse);
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        for (i2 = 0; i2 < unitsInCommon; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] | set.bits[i2];
        }
        while (i2 < set.unitsInUse) {
            this.bits[i2] = set.bits[i2];
            ++i2;
        }
        if (this.unitsInUse < set.unitsInUse) {
            this.unitsInUse = set.unitsInUse;
        }
    }

    public void xor(BiDiBitSet set) {
        int i2;
        int unitsInCommon;
        if (this.unitsInUse >= set.unitsInUse) {
            unitsInCommon = set.unitsInUse;
        } else {
            unitsInCommon = this.unitsInUse;
            int newUnitsInUse = set.unitsInUse;
            this.ensureCapacity(newUnitsInUse);
            this.unitsInUse = newUnitsInUse;
        }
        for (i2 = 0; i2 < unitsInCommon; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] ^ set.bits[i2];
        }
        while (i2 < set.unitsInUse) {
            this.bits[i2] = set.bits[i2];
            ++i2;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(BiDiBitSet set) {
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        for (int i2 = 0; i2 < unitsInCommon; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] & (set.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateUnitsInUse();
    }

    public int hashCode() {
        long h2 = 1234L;
        int i2 = this.bits.length;
        while (--i2 >= 0) {
            h2 ^= this.bits[i2] * (long)(i2 + 1);
        }
        return (int)(h2 >> 32 ^ h2);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object obj) {
        int i2;
        if (!(obj instanceof BiDiBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BiDiBitSet set = (BiDiBitSet)obj;
        int minUnitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        for (i2 = 0; i2 < minUnitsInUse; ++i2) {
            if (this.bits[i2] == set.bits[i2]) continue;
            return false;
        }
        if (this.unitsInUse > minUnitsInUse) {
            for (i2 = minUnitsInUse; i2 < this.unitsInUse; ++i2) {
                if (this.bits[i2] == 0L) continue;
                return false;
            }
        } else {
            for (i2 = minUnitsInUse; i2 < set.unitsInUse; ++i2) {
                if (set.bits[i2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        BiDiBitSet result = null;
        try {
            result = (BiDiBitSet)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        result.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, this.unitsInUse);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    public String toString() {
        int numBits = this.unitsInUse << 6;
        StringBuffer buffer = new StringBuffer(8 * numBits + 2);
        String separator = "";
        buffer.append('{');
        for (int i2 = 0; i2 < numBits; ++i2) {
            if (!this.get(i2)) continue;
            buffer.append(separator);
            separator = ", ";
            buffer.append(i2);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

