/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private Map<Path, File> files = new LinkedHashMap<Path, File>();

    public void add(Path pathInZipPrefix, File filePrefix, String suffix) {
        this.add(new Path(pathInZipPrefix, suffix), new File(filePrefix, suffix));
    }

    public void add(Path pathInZip, File file) {
        if (file != null && file.isDirectory()) {
            File[] files;
            for (File entry : files = file.listFiles()) {
                this.add(new Path(pathInZip, entry.getName()), entry);
            }
        } else {
            this.files.put(pathInZip, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(OutputStream destination) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(destination));
        if (this.files.isEmpty()) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        try {
            out.setComment("zip, created by FishEye");
            for (Map.Entry<Path, File> entry : this.files.entrySet()) {
                String msg;
                Path path = entry.getKey();
                File file = entry.getValue();
                if (file == null) {
                    msg = "Not adding file for path: " + path + ". File is null.";
                    Logs.APP_LOG.warn((Object)msg);
                    continue;
                }
                if (!file.exists()) {
                    msg = "File does not exist " + file.getAbsolutePath() + " (as path " + path + ").";
                    Logs.APP_LOG.info((Object)msg);
                    continue;
                }
                msg = "adding entry: " + file.getAbsolutePath() + ", as " + path;
                Logs.APP_LOG.debug((Object)msg);
                ZipEntry zentry = new ZipEntry(path.toString());
                zentry.setTime(file.lastModified());
                out.putNextEntry(zentry);
                try {
                    IOHelper.copyStream(file, (OutputStream)out);
                }
                catch (IOException e2) {
                    msg = "Could not copy file " + file;
                    Logs.APP_LOG.error((Object)msg, (Throwable)e2);
                    throw e2;
                }
                out.closeEntry();
            }
        }
        finally {
            out.finish();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File source, File dest) throws IOException {
        if (dest == null) {
            throw new NullPointerException("Destination is null");
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!dest.isDirectory()) {
            throw new IOException("Destination must be a directory. (" + dest.getName() + ")");
        }
        ZipFile zipFile = new ZipFile(source);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zentry = entries.nextElement();
            File f2 = new File(dest, zentry.getName());
            f2.getParentFile().mkdirs();
            if (zentry.isDirectory()) continue;
            OutputStream out = null;
            try {
                BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(zentry));
                out = new BufferedOutputStream(new FileOutputStream(f2));
                IOHelper.copyStream((InputStream)in, out);
                out.flush();
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }
}

