/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;

public class XmlUtils {
    private static final char BACKSLASH = '\\';
    private static final CharOpenHashSet illegalChars;
    private static final Char2ObjectOpenHashMap<String> charToUnicode;
    private final StringBuilder copy = new StringBuilder();

    public static char[] getIllegalChars() {
        return illegalChars.toCharArray();
    }

    public static boolean isIllegalChar(char c2) {
        return illegalChars.contains(c2);
    }

    public String unicodeEncode(String string) {
        if (string == null) {
            return null;
        }
        this.copy.setLength(0);
        boolean copied = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            String s2 = (String)charToUnicode.get(c2);
            if (s2 != null && !copied) {
                this.copy.append(string.substring(0, i2));
                copied = true;
            }
            if (!copied) continue;
            if (s2 == null) {
                this.copy.append(c2);
                continue;
            }
            this.copy.append(s2);
        }
        return copied ? this.copy.toString() : string;
    }

    public String unicodeDecode(String string) {
        if (string == null) {
            return null;
        }
        this.copy.setLength(0);
        boolean copied = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (!copied) {
                    this.copy.append(string.substring(0, i2));
                    copied = true;
                }
                if (string.charAt(++i2) == '\\') {
                    this.copy.append('\\');
                    continue;
                }
                String value = string.substring(++i2, i2 + 4);
                this.copy.append((char)Integer.parseInt(value, 16));
                i2 += 3;
                continue;
            }
            if (!copied) continue;
            this.copy.append(c2);
        }
        return copied ? this.copy.toString() : string;
    }

    static {
        String escapeString = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff";
        illegalChars = new CharOpenHashSet();
        charToUnicode = new Char2ObjectOpenHashMap();
        for (int i2 = 0; i2 < "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff".length(); ++i2) {
            char c2 = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\ufffe\uffff".charAt(i2);
            illegalChars.add(c2);
            charToUnicode.put(c2, (Object)String.format("\\u%04X", c2));
        }
        charToUnicode.put('\\', (Object)"\\\\");
    }
}

