/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.Disposer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class WithDisposerAspect {
    @Pointcut(value="within(@com.cenqua.fisheye.util.WithDisposer *)")
    private void annotatedClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="annotatedClass()")
    public Object withDisposer(ProceedingJoinPoint method) throws Throwable {
        boolean hadDisposer = Disposer.hasThreadInstance();
        try {
            if (!hadDisposer) {
                Disposer.pushThreadInstance();
            }
            Object object = method.proceed();
            return object;
        }
        finally {
            if (!hadDisposer) {
                Disposer.popThreadInstance();
            }
        }
    }
}

