/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    Pattern numericPrefix = Pattern.compile("([0-9]+).*");
    private final int major;
    private final int minor;
    private final int maintenance;

    public VersionNumber(String number) throws IllegalArgumentException {
        String[] tokens = number.split("\\.", 4);
        this.major = tokens.length > 0 && tokens[0].length() > 0 ? Integer.parseInt(tokens[0]) : 0;
        this.minor = tokens.length > 1 ? Integer.parseInt(tokens[1]) : 0;
        this.maintenance = tokens.length > 2 ? Integer.parseInt(this.maintentanceToken(number, tokens[2])) : 0;
    }

    private String maintentanceToken(String number, String token) {
        Matcher matcher = this.numericPrefix.matcher(token);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Unexpected 'maintenance' field '" + token + "' of version number '" + number + "', couldn't match numeric prefix.");
    }

    public VersionNumber(int major, int minor, int maintenance) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
    }

    public int getMaintenance() {
        return this.maintenance;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VersionNumber that = (VersionNumber)o2;
        if (this.maintenance != that.maintenance) {
            return false;
        }
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.maintenance;
        return result;
    }

    @Override
    public int compareTo(VersionNumber v2) {
        if (this.major != v2.major) {
            return this.major - v2.major;
        }
        if (this.minor != v2.minor) {
            return this.minor - v2.minor;
        }
        if (this.maintenance != v2.maintenance) {
            return this.maintenance - v2.maintenance;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.maintenance;
    }

    public int toInteger() {
        return (this.major * 1000 + this.minor) * 1000 + this.maintenance;
    }
}

