/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class UrlUtils {
    private static final String URL_PATTERN_STRING = "(\\w{2,6}://)([^@\\s:]+)??(?::([^@\\s:]+))??(?:@?([^@\\s]+))";
    private static final String OBFUSCATION_PATTERN_STRING = "(\\w{2,6}://)([^@\\s:]+)(:[^@\\s:]+)(@[^@\\s]+)";
    private static final String OBFUSCATION_REPLACEMENT_PATTERN = "$1$2:XXXX$4";
    private static final Pattern URL_PATTERN = Pattern.compile("(\\w{2,6}://)([^@\\s:]+)??(?::([^@\\s:]+))??(?:@?([^@\\s]+))");
    private static final Pattern URL_PORT_PATTERN = Pattern.compile("^[^:/]+:(\\d+)");
    private static final int PROTOCOL_GROUP = 1;
    private static final int USERNAME_GROUP = 2;
    private static final int PASSWORD_GROUP = 3;
    private static final int CLEAN_URL_GROUP = 4;

    public static boolean isUrl(String string) {
        return URL_PATTERN.matcher(string).matches();
    }

    public static UrlDetails parse(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            return new UrlDetails(matcher.group(2), matcher.group(3), matcher.group(1), matcher.group(4));
        }
        throw new IllegalArgumentException(url + " is not a valid url");
    }

    public static String addAuthentication(String url, String username) {
        return UrlUtils.addAuthentication(url, username, null);
    }

    public static Pair<String, String> removePassword(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            return new Pair<String, String>(UrlUtils.createUrl(matcher.group(1), matcher.group(2), null, matcher.group(4)), matcher.group(3));
        }
        return new Pair<String, Object>(url, null);
    }

    private static String createUrl(String protocol, String username, String password, String simpleUrl) {
        StringBuilder urlBuilder = new StringBuilder().append(protocol);
        if (StringUtils.isNotBlank((String)username)) {
            urlBuilder.append(username);
            if (StringUtils.isNotBlank((String)password)) {
                urlBuilder.append(":").append(password);
            }
            urlBuilder.append("@");
        }
        urlBuilder.append(simpleUrl);
        return urlBuilder.toString();
    }

    public static String addAuthentication(String url, String username, String password) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            username = StringUtils.isBlank((String)username) ? matcher.group(2) : FishEyeURLEncoder.uriEncode(username);
            password = StringUtils.isBlank((String)password) ? matcher.group(3) : FishEyeURLEncoder.uriEncode(password);
            return UrlUtils.createUrl(matcher.group(1), username, password, matcher.group(4));
        }
        throw new IllegalArgumentException(url + " is not a valid url");
    }

    public static String addPort(String url, int port) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            String cleanUrl = matcher.group(4);
            int offset = matcher.start(4);
            if (StringUtils.isNotEmpty((String)cleanUrl)) {
                Matcher portMatcher = URL_PORT_PATTERN.matcher(cleanUrl);
                if (portMatcher.find()) {
                    return url.substring(0, offset + portMatcher.start(1)) + Integer.toString(port) + url.substring(offset + portMatcher.end(1));
                }
                int pos = cleanUrl.indexOf(47);
                if (pos != -1) {
                    return url.substring(0, offset + pos) + ':' + Integer.toString(port) + url.substring(offset + pos);
                }
                return url + ':' + Integer.toString(port);
            }
            throw new IllegalArgumentException(url + " is not a valid url");
        }
        throw new IllegalArgumentException(url + " is not a valid url");
    }

    public static String removePort(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            String cleanUrl = matcher.group(4);
            int offset = matcher.start(4);
            if (StringUtils.isNotEmpty((String)cleanUrl)) {
                Matcher portMatcher = URL_PORT_PATTERN.matcher(cleanUrl);
                if (portMatcher.find()) {
                    return url.substring(0, offset + portMatcher.start(1) - 1) + url.substring(offset + portMatcher.end(1));
                }
                return url;
            }
            throw new IllegalArgumentException(url + " is not a valid url");
        }
        throw new IllegalArgumentException(url + " is not a valid url");
    }

    public static String obfucscatePasswordsInString(String string) {
        return string.replaceAll(OBFUSCATION_PATTERN_STRING, OBFUSCATION_REPLACEMENT_PATTERN);
    }

    public static String getSiteUrl() {
        return CrucibleFilter.hasContext() ? CrucibleFilter.getSiteURL() : AppConfig.getsConfig().getSiteURL();
    }

    public static class UrlDetails {
        public String username;
        public String password;
        public String protocol;
        public String simpleUrl;

        public UrlDetails(String username, String password, String protocol, String simpleUrl) {
            this.username = username;
            this.password = password;
            this.protocol = protocol;
            this.simpleUrl = simpleUrl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 31 * result + (this.simpleUrl == null ? 0 : this.simpleUrl.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UrlDetails other = (UrlDetails)obj;
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
                return false;
            }
            if (this.simpleUrl == null ? other.simpleUrl != null : !this.simpleUrl.equals(other.simpleUrl)) {
                return false;
            }
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }
    }
}

