/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class Triple<T1, T2, T3> {
    private final T1 comp1;
    private final T2 comp2;
    private final T3 comp3;

    public Triple(T1 comp1, T2 comp2, T3 comp3) {
        this.comp1 = comp1;
        this.comp2 = comp2;
        this.comp3 = comp3;
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> newInstance(T1 comp1, T2 comp2, T3 comp3) {
        return new Triple<T1, T2, T3>(comp1, comp2, comp3);
    }

    public T1 getFirst() {
        return this.comp1;
    }

    public T2 getSecond() {
        return this.comp2;
    }

    public T3 getThird() {
        return this.comp3;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Triple triple = (Triple)o2;
        if (this.comp1 != null ? !this.comp1.equals(triple.comp1) : triple.comp1 != null) {
            return false;
        }
        if (this.comp2 != null ? !this.comp2.equals(triple.comp2) : triple.comp2 != null) {
            return false;
        }
        return !(this.comp3 != null ? !this.comp3.equals(triple.comp3) : triple.comp3 != null);
    }

    public int hashCode() {
        int result = this.comp1 != null ? this.comp1.hashCode() : 0;
        result = 31 * result + (this.comp2 != null ? this.comp2.hashCode() : 0);
        result = 31 * result + (this.comp3 != null ? this.comp3.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.comp1 + ", " + this.comp2 + ", " + this.comp3 + ")";
    }
}

