/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import org.apache.log4j.Logger;

public class Timer {
    private final Logger log;
    private final long startTime;
    private final String timerName;

    public Timer(String timerName) {
        this(Logs.APP_LOG, timerName);
    }

    public Timer(Logger log, String timerName) {
        this.log = log;
        this.timerName = timerName;
        if (this.enabled()) {
            this.output("-> " + timerName + this.getMemString());
        }
        this.startTime = System.currentTimeMillis();
    }

    public Timer(String loggerName, String timerName) {
        this(Logger.getLogger((String)loggerName), timerName);
    }

    private void output(String message) {
        this.log.debug((Object)message);
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    private String getMemString() {
        long currentHeapSize = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long currentUsed = currentHeapSize - freeMem;
        return " mem_usage = " + currentUsed + " heapsize = " + currentHeapSize + " freemem = " + freeMem;
    }

    private String getTimeString() {
        long time = this.getTime();
        return " time " + time + " millis";
    }

    public long getTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void mark(String markPoint) {
        if (this.enabled()) {
            String timeString = this.getTimeString();
            this.output("-- " + this.timerName + " at " + markPoint + timeString + this.getMemString());
        }
    }

    public void end() {
        this.end("");
    }

    public void end(String endMsg) {
        if (this.enabled()) {
            String timeString = this.getTimeString();
            this.output("<- " + this.timerName + " " + endMsg + timeString + this.getMemString());
        }
    }
}

