/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class Throttle {
    private volatile long millisPerOperation = 0L;
    private long lastOperation = 0L;

    public synchronized void setOperationsPerSecond(float opsPerSecond) {
        this.millisPerOperation = (long)(1000.0 / (double)opsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        if (this.millisPerOperation != 0L) {
            Throttle throttle = this;
            synchronized (throttle) {
                long now = System.currentTimeMillis();
                while (now - this.lastOperation < this.millisPerOperation) {
                    try {
                        long delay = this.lastOperation + this.millisPerOperation - now + 1L;
                        if (delay > 0L) {
                            Thread.sleep(delay);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
                this.lastOperation = now;
            }
        }
    }
}

