/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SumMap<K>
implements Map<K, Integer> {
    private Object2IntMap<K> map;

    public SumMap(Object2IntMap<K> map) {
        this.map = map;
    }

    @Override
    public Integer put(K key, Integer value) {
        return (Integer)this.map.put(key, (Object)value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o2) {
        return this.map.containsKey(o2);
    }

    @Override
    public boolean containsValue(Object o2) {
        return this.map.containsValue(o2);
    }

    @Override
    public Integer get(Object o2) {
        return (Integer)this.map.get(o2);
    }

    @Override
    public Integer remove(Object o2) {
        return (Integer)this.map.remove(o2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        return this.map.entrySet();
    }

    public ObjectSet<Object2IntMap.Entry<K>> object2IntEntrySet() {
        return this.map.object2IntEntrySet();
    }

    public void addValue(K key, int value) {
        if (value != 0) {
            int oldValue = this.map.getInt(key);
            if (value + oldValue == 0) {
                this.map.remove(key);
            } else {
                this.map.put(key, value + oldValue);
            }
        }
    }

    private void addAllValues(Object2IntMap<K> map) {
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            this.addValue(entry.getKey(), entry.getIntValue());
        }
    }

    public int getTotal() {
        int total = 0;
        IntIterator intIterator = this.map.values().iterator();
        while (intIterator.hasNext()) {
            int lines = (Integer)intIterator.next();
            total += lines;
        }
        return total;
    }

    public String toString() {
        return this.map.toString();
    }

    public static <K> SumMap<K> getInstance(K key, int value) {
        SumMap<K> map = SumMap.getInstance(key);
        map.addValue(key, value);
        return map;
    }

    public int getInt(K key) {
        return this.map.getInt(key);
    }

    public static <K> SumMap<K> getInstance(K type) {
        return new SumMap<K>(new Object2IntOpenHashMap());
    }

    public static <K> SumMap<K> getInstance() {
        return new SumMap<K>(new Object2IntOpenHashMap());
    }

    public static <K> SumMap<K> getTreeInstance() {
        return new SumMap<K>(new Object2IntAVLTreeMap());
    }

    public static <K> SumMap<K> getDifference(SumMap<K> map1, SumMap<K> map2) {
        SumMap<Object> map = SumMap.getInstance();
        if (map1 != null) {
            super.addAllValues(map1.map);
        }
        if (map2 == null) {
            return map;
        }
        for (Object2IntMap.Entry i2 : map2.object2IntEntrySet()) {
            map.addValue(i2.getKey(), -i2.getIntValue());
        }
        return map;
    }

    public Object2IntMap<K> getMap() {
        return this.map;
    }

    public void subtractAllValues(SumMap<K> map) {
        for (Object2IntMap.Entry e2 : map.object2IntEntrySet()) {
            this.addValue(e2.getKey(), -e2.getIntValue());
        }
    }
}

