/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.LineWriter;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    public static StringBuffer pad(StringBuffer buf, int i2, int pad) {
        String s2 = Integer.toString(i2);
        while (pad > s2.length()) {
            buf.append('0');
            --pad;
        }
        buf.append(s2);
        return buf;
    }

    public static void append(StringBuilder buf, String pad, int padCount) {
        for (int i2 = 0; i2 < padCount; ++i2) {
            buf.append(pad);
        }
    }

    public static String stripEOL(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.endsWith(LineWriter.NEWLINE_STR)) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        if (s2.endsWith(LineWriter.CARRIAGERETURN_STR)) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    public static int stringHashCode(CharSequence line) {
        int h2 = 0;
        int len = line.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = line.charAt(i2);
            h2 = 31 * h2 + c2;
        }
        return h2;
    }

    public static boolean isPrintableAscii(char c2) {
        return ' ' <= c2 && c2 <= '~';
    }

    @VisibleForTesting
    static int indexOfEOL(String str) {
        int nlIdx = str.indexOf(10);
        int crIdx = str.indexOf(13);
        return StringUtil.minPositive(nlIdx, crIdx);
    }

    public static String firstLineOf(String str, int limit, boolean hardLimit, boolean wholeWord, boolean addElipsis) {
        String elip;
        if (str == null) {
            return "";
        }
        String tmp = str.trim();
        int eolIdx = StringUtil.indexOfEOL(tmp);
        if (limit == -1) {
            return eolIdx == -1 ? tmp : tmp.substring(0, eolIdx);
        }
        if (eolIdx > 0 && eolIdx < limit) {
            return tmp.substring(0, eolIdx);
        }
        if (tmp.length() < limit) {
            return tmp;
        }
        String string = elip = addElipsis ? "..." : "";
        if (!wholeWord) {
            return tmp.substring(0, limit) + elip;
        }
        int before = StringUtil.nearestWhiteSpaceBefore(tmp, limit);
        int after = StringUtil.nearestWhiteSpaceAfter(tmp, limit);
        if (!hardLimit) {
            int space = limit - before > Math.abs(after - limit) ? after : before;
            return space != -1 ? tmp.substring(0, space) + elip : tmp.substring(0, limit) + elip;
        }
        return before != -1 ? tmp.substring(0, before) + elip : tmp.substring(0, limit) + elip;
    }

    public static String abbreviateText(String str, int limit) {
        return StringUtil.firstLineOf(str, limit, true, false, true);
    }

    public static String abbreviateText(String str, int frontLimit, int backLimit) {
        String tmp = str.trim();
        int eolIdx = StringUtil.indexOfEOL(tmp);
        String firstLine = eolIdx > 0 ? tmp.substring(eolIdx - backLimit, eolIdx) : str;
        if (frontLimit < 0 || backLimit < 0 || firstLine.length() <= frontLimit + backLimit + 3) {
            return firstLine;
        }
        int backStringIndex = Math.max(frontLimit, firstLine.length() - backLimit);
        return StringUtil.firstLineOf(firstLine.substring(0, backStringIndex), frontLimit, true, false, true) + firstLine.substring(backStringIndex);
    }

    @VisibleForTesting
    static int nearestWhiteSpaceBefore(String str, int idx) {
        int before;
        int n2 = before = idx < str.length() ? idx : str.length() - 1;
        while (before > -1 && !Character.isWhitespace(str.charAt(before))) {
            --before;
        }
        return before;
    }

    public static String truncate(String toTruncate, int length, boolean addElipsis) {
        String truncated;
        if (toTruncate.length() > length) {
            truncated = toTruncate.substring(0, length);
            if (addElipsis) {
                truncated = truncated + "...";
            }
        } else {
            truncated = toTruncate;
        }
        return truncated;
    }

    @VisibleForTesting
    static int nearestWhiteSpaceAfter(String str, int idx) {
        int after;
        for (after = idx; after < str.length() && !Character.isWhitespace(str.charAt(after)); ++after) {
        }
        after = after == str.length() ? -1 : after;
        return after;
    }

    private static int minPositive(int a2, int b2) {
        if (a2 < 0 && b2 < 0) {
            return -1;
        }
        if (a2 < 0 || b2 < 0) {
            return a2 < 0 ? b2 : a2;
        }
        return Math.min(a2, b2);
    }

    public static Path asPath(String path) {
        return new Path(path);
    }

    public static String escapeSQL(Path path) {
        return path.getPath().replace("%", "!%' escape '!'");
    }

    public static String formatList(List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            sb.append(elements.get(i2));
            if (i2 < elements.size() - 2) {
                sb.append(", ");
                continue;
            }
            if (i2 >= elements.size() - 1) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    public static String trim(String s2) {
        return StringUtils.trim((String)s2);
    }

    public static String toLower(String s2) {
        return s2.toLowerCase(Locale.US);
    }

    public static String removeSpaces(String s2) {
        return s2.replace(" ", "");
    }

    public static boolean equalsWithNullsAsEmpty(String a2, String b2) {
        return StringUtils.defaultString((String)a2).equals(StringUtils.defaultString((String)b2));
    }

    public static byte[] getBytesInUTF8(String value) {
        byte[] input = null;
        try {
            input = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new AssertionError((Object)("UTF-8 was supposed to be supported by every JVM but it is not: " + e2.getMessage()));
        }
        return input;
    }

    public static String hexEncode(byte[] source) {
        return StringUtil.hexEncode(source, false);
    }

    public static String hexEncode(byte[] source, boolean upperCase) {
        if (upperCase) {
            return new String(Hex.encodeHex((byte[])source)).toUpperCase();
        }
        return new String(Hex.encodeHex((byte[])source));
    }

    public static Date strToDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(dateStr));
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.debug((Object)("Date detail passed by SCM not a long timestamp: " + dateStr));
            return null;
        }
    }
}

