/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SortedList<T>
implements List<T> {
    private final ObjectArrayList<T> list;
    private final Comparator<T> comp;

    public SortedList(Iterable<T> original, Comparator<T> comp) {
        this(comp, Iterables.size(original));
        for (T item : original) {
            this.add(item);
        }
    }

    public SortedList(Comparator<T> comp) {
        this(comp, 10);
    }

    private SortedList(Comparator<T> comp, int minCapacity) {
        this.comp = comp;
        this.list = new ObjectArrayList(minCapacity);
    }

    public int binarySearch(T value) {
        return this.binarySearch(value, 0, this.list.size());
    }

    public int binarySearch(T value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        int size = this.list.size();
        if (toIndex > size) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex < size && this.comp.compare(value, this.list.get(fromIndex)) <= 0) {
            return fromIndex;
        }
        if (toIndex < size && this.comp.compare(value, this.list.get(toIndex)) >= 0) {
            return toIndex;
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this.list.get(mid);
            int cmp = this.comp.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    @Override
    public boolean add(T value) {
        this.addAndReturnIndex(value);
        return true;
    }

    public int addAndReturnIndex(T value) {
        int idx = this.binarySearch(value);
        assert (idx >= 0);
        assert (idx <= this.list.size());
        if (idx == this.list.size()) {
            this.list.add(value);
        } else {
            this.list.add(idx, value);
        }
        return idx;
    }

    @Override
    public T getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    @Override
    public T get(int i2) {
        return (T)this.list.get(i2);
    }

    @Override
    public T set(int i2, T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i2, T t2) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T remove(int i2) {
        return (T)this.list.remove(i2);
    }

    @Override
    public int indexOf(Object o2) {
        return this.list.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.list.lastIndexOf(o2);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ObjectIterators.UnmodifiableListIterator(this.list.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int i2) {
        return new ObjectIterators.UnmodifiableListIterator(this.list.listIterator(i2));
    }

    @Override
    public Iterator<T> iterator() {
        return new ObjectIterators.UnmodifiableIterator((ObjectIterator)this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.list.toArray((Object[])ts);
    }

    @Override
    public List<T> subList(int index, int endIndex) {
        return this.list.subList(index, endIndex);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.list.contains(o2);
    }

    @Override
    public boolean remove(Object o2) {
        return this.list.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.list.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        for (T t2 : ts) {
            this.add(t2);
        }
        return true;
    }

    @Override
    public boolean addAll(int i2, Collection<? extends T> ts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.list.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.list.retainAll(objects);
    }

    public void remove(int from, int to) {
        this.list.subList(from, to).clear();
    }
}

