/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.fugue.Option;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Preconditions;

public class RevisionDateRange {
    private static final int UNSET_REV = -1;
    private Long min;
    private Long max;
    private Integer minRevId = -1;
    private Integer maxRevId = -1;

    public boolean update(long val, int revId) {
        if (this.hasMinMax()) {
            boolean updated = false;
            if (val < this.min) {
                this.min = val;
                this.minRevId = revId;
                updated = true;
            }
            if (val > this.max) {
                this.max = val;
                this.maxRevId = revId;
                updated = true;
            }
            return updated;
        }
        this.min = this.max = Long.valueOf(val);
        this.maxRevId = this.minRevId = Integer.valueOf(revId);
        return true;
    }

    public Option<Long> getMin() {
        return Option.option((Object)this.min);
    }

    public Option<Long> getMax() {
        return Option.option((Object)this.max);
    }

    public Integer getMinRevId() {
        return this.minRevId;
    }

    public Integer getMaxRevId() {
        return this.maxRevId;
    }

    public boolean hasMinMax() {
        return this.min != null && this.max != null;
    }

    public boolean hasRevisionInfo() {
        return this.hasMinRevisionInfo() && this.hasMaxRevisionInfo();
    }

    public boolean hasMaxRevisionInfo() {
        return this.maxRevId != -1;
    }

    public boolean hasMinRevisionInfo() {
        return this.minRevId != -1;
    }

    public String toString() {
        if (this.hasMinMax()) {
            return "[" + this.min + "(" + this.minRevId + ")-" + this.max + "(" + this.maxRevId + ")]";
        }
        return "[not set]";
    }

    public void writeToCursor(y cu) {
        cu.a(this.hasMinMax());
        cu.b(this.getMin().get());
        cu.b(this.getMax().get());
        cu.b(this.getMinRevId());
        cu.b(this.getMaxRevId());
    }

    public int readFromCursor(y cu, int off) {
        boolean set = cu.s(off);
        off = cu.t(off);
        if (set) {
            this.min = cu.v(off);
            off = cu.w(off);
            this.max = cu.v(off);
            off = cu.w(off);
            if (cu.e() > off) {
                this.minRevId = (int)cu.v(off);
                off = cu.w(off);
                this.maxRevId = (int)cu.v(off);
                off = cu.w(off);
            } else {
                this.minRevId = this.maxRevId = Integer.valueOf(-1);
            }
        }
        return off;
    }

    public void reset() {
        this.max = null;
        this.min = null;
        this.minRevId = this.maxRevId = Integer.valueOf(-1);
    }

    public MinMaxLongRange toMinMaxLongRange() {
        Preconditions.checkState((boolean)this.hasMinMax(), (Object)"minMax not set");
        return new MinMaxLongRange(this.min, this.max);
    }
}

