/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.AbstractCollection;
import java.util.Iterator;

public class ReversedLongSortedSet
extends AbstractCollection<Long> {
    private final LongSortedSet set;

    public ReversedLongSortedSet(LongSortedSet set) {
        this.set = set;
    }

    @Override
    public Iterator<Long> iterator() {
        return new LongBidirectionalReverseIterator(this.set);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public static class LongBidirectionalReverseIterator
    extends AbstractIterator<Long> {
        private final LongBidirectionalIterator iterator;

        public LongBidirectionalReverseIterator(LongSortedSet set) {
            this.iterator = set.isEmpty() ? LongIterators.EMPTY_ITERATOR : set.iterator(set.lastLong());
        }

        protected Long computeNext() {
            if (this.iterator.hasPrevious()) {
                return (Long)this.iterator.previous();
            }
            this.endOfData();
            return null;
        }
    }
}

