/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.rep.activity.ActivityLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

public class RecentHistory {
    private final ConcurrentSkipListSet<ActivityLog> current = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<ActivityLog> archive = new ConcurrentSkipListSet();
    private int capacity = 0;

    public RecentHistory(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.capacity = capacity;
    }

    public void add(ActivityLog item) {
        this.current.add(item);
    }

    public void archive(ActivityLog item) {
        if (item != null && this.current.remove(item)) {
            this.archive.add(item);
            if (this.archive.size() > this.capacity) {
                this.archive.pollLast();
            }
            return;
        }
        throw new IllegalArgumentException("Can't archive an item that isn't in the list of current items");
    }

    public List<ActivityLog> getAllItems() {
        ArrayList<ActivityLog> recent = new ArrayList<ActivityLog>(this.archive.size() + this.current.size());
        recent.addAll(this.current);
        recent.addAll(this.archive);
        return recent;
    }

    public List<ActivityLog> getCurrentItems() {
        ArrayList<ActivityLog> result = new ArrayList<ActivityLog>(this.current.size());
        result.addAll(this.current);
        return result;
    }

    public List<ActivityLog> getArchivedItems() {
        ArrayList<ActivityLog> result = new ArrayList<ActivityLog>(this.archive.size());
        result.addAll(this.archive);
        return result;
    }

    public int size() {
        return this.current.size() + this.archive.size();
    }
}

