/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PropertiesUtil {
    public static Properties loadFromString(String str) {
        Properties p2 = new Properties();
        return PropertiesUtil.loadFromString(p2, str);
    }

    public static Properties loadFromString(Properties p2, String str) {
        try {
            p2.load(new ByteArrayInputStream(str.getBytes()));
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"Problem parsing Properties from string", (Throwable)e2);
        }
        return p2;
    }

    public static String saveToString(Properties props) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, null);
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)"Problem saving Properties as string", (Throwable)e2);
        }
        return new String(out.toByteArray());
    }

    public static String saveToStringSansComments(Properties props) {
        return PropertiesUtil.saveToString(props).replaceAll("^#.*\n", "");
    }

    public static Properties loadFromFile(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                properties.load(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return properties;
    }

    public static void writeToFile(Properties properties, File file) throws IOException {
        FileOutputStream os = FileUtils.openOutputStream((File)file);
        try {
            properties.store(os, null);
        }
        catch (Throwable throwable) {
            IOHelper.close(os);
            throw throwable;
        }
        IOHelper.close(os);
    }
}

