/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.extras.common.LicenseException;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.util.ProductUpdateInfo;
import com.cenqua.fisheye.util.ProductUpdateParseException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class ProductUpdateInfoParser {
    private final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private final SAXBuilder xmlParser = new SAXBuilder(false);
    private final FisheyeVersionInfo currentVersion;

    public ProductUpdateInfoParser(FisheyeVersionInfo currentVersion) {
        if (currentVersion == null) {
            throw new IllegalArgumentException("null");
        }
        this.currentVersion = currentVersion;
    }

    public ProductUpdateInfo parse(String xml) throws ProductUpdateParseException {
        try {
            return this.parse(IOUtils.toInputStream((String)xml));
        }
        catch (IOException ioe) {
            throw new ProductUpdateParseException("Unable to parse product update description.", ioe);
        }
    }

    public ProductUpdateInfo parse(InputStream in) throws ProductUpdateParseException, IOException {
        String error = "Unable to parse product update description.";
        try {
            Document doc = this.xmlParser.build(in);
            String versionString = ((Element)XPath.newInstance((String)"/version/number").selectSingleNode((Object)doc)).getValue();
            String downloadUrl = ((Element)XPath.newInstance((String)"/version/downloadUrl").selectSingleNode((Object)doc)).getValue();
            Date buildDate = this.dateFormatter.parse(((Element)XPath.newInstance((String)"/version/buildDate").selectSingleNode((Object)doc)).getValue());
            Date lastFreeBuild = this.currentVersion.getLicense().getLatestBuildAllowedValue();
            return new ProductUpdateInfo(versionString, downloadUrl, buildDate.compareTo(lastFreeBuild) > 0, buildDate);
        }
        catch (NullPointerException e2) {
            throw new ProductUpdateParseException("Unable to parse product update description.", e2);
        }
        catch (JDOMException e3) {
            throw new ProductUpdateParseException("Unable to parse product update description.", e3);
        }
        catch (LicenseException e4) {
            throw new ProductUpdateParseException("Unable to parse product update description.", e4);
        }
        catch (ParseException e5) {
            throw new ProductUpdateParseException("Unable to parse product update description.", e5);
        }
    }
}

