/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class Pair<T1, T2> {
    private final T1 comp1;
    private final T2 comp2;

    protected Pair(T1 comp1, T2 comp2) {
        this.comp1 = comp1;
        this.comp2 = comp2;
    }

    public boolean isNull() {
        return this.comp1 == null && this.comp2 == null;
    }

    public static <T1, T2> Pair<T1, T2> newInstance(T1 comp1, T2 comp2) {
        return new Pair<T1, T2>(comp1, comp2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)o2;
        if (this.comp1 != null ? !this.comp1.equals(pair.comp1) : pair.comp1 != null) {
            return false;
        }
        return !(this.comp2 != null ? !this.comp2.equals(pair.comp2) : pair.comp2 != null);
    }

    public int hashCode() {
        int result = this.comp1 != null ? this.comp1.hashCode() : 0;
        result = 29 * result + (this.comp2 != null ? this.comp2.hashCode() : 0);
        return result;
    }

    public T1 getFirst() {
        return this.comp1;
    }

    public T2 getSecond() {
        return this.comp2;
    }

    public String toString() {
        return "(" + this.comp1 + ", " + this.comp2 + ")";
    }
}

