/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;

public class NamedExecution {
    private final String startingName = Thread.currentThread().getName();

    public NamedExecution(String name) {
        String newName = StringUtils.substringBefore((String)this.startingName, (String)" ") + " " + name;
        Thread.currentThread().setName(newName);
    }

    public void end() {
        Thread.currentThread().setName(this.startingName);
    }

    public void run(Runnable runnable) {
        try {
            runnable.run();
        }
        finally {
            this.end();
        }
    }

    public <T> T call(Callable<T> callable) throws Exception {
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            this.end();
        }
    }
}

