/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.io.Serializable;

public class MinMaxLongRange
implements Serializable {
    private long min;
    private long max;
    private boolean set = false;

    public MinMaxLongRange() {
    }

    public MinMaxLongRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.set = true;
    }

    public boolean add(long val) {
        if (this.set) {
            boolean updated = false;
            if (val < this.min) {
                this.min = val;
                updated = true;
            }
            if (val > this.max) {
                this.max = val;
                updated = true;
            }
            return updated;
        }
        this.min = val;
        this.max = val;
        this.set = true;
        return true;
    }

    public void add(MinMaxLongRange range) {
        if (!range.isSet()) {
            return;
        }
        this.add(range.getMin());
        this.add(range.getMax());
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean isSet() {
        return this.set;
    }

    public String toString() {
        if (this.set) {
            return "[" + this.min + "-" + this.max + ")]";
        }
        return "[not set]";
    }

    public void reset() {
        this.set = false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MinMaxLongRange that = (MinMaxLongRange)o2;
        if (this.max != that.max) {
            return false;
        }
        if (this.min != that.min) {
            return false;
        }
        return this.set == that.set;
    }

    public int hashCode() {
        int result = (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (this.set ? 1 : 0);
        return result;
    }
}

