/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public class MD5 {
    private static final Pattern MD5_PATTERN = Pattern.compile("^(?:[a-fA-F0-9]){32}$");

    public static String hash(String input) {
        return new String(Hex.encodeHex((byte[])MD5.hashAsBytes(input)));
    }

    public static byte[] hashAsBytes(String input) {
        if (input == null) {
            input = "";
        }
        try {
            byte[] bytes = new byte[input.length()];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)input.charAt(i2);
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new UnsupportedOperationException("MD5 not supported in this JVM");
        }
    }

    public static byte[] hexDecode(String hash) {
        if (hash.length() % 2 != 0) {
            throw new IllegalArgumentException("Argument length must be a multiple of two");
        }
        byte[] results = new byte[hash.length() / 2];
        for (int i2 = 0; i2 < results.length; ++i2) {
            String b2 = hash.substring(i2 * 2, i2 * 2 + 2);
            results[i2] = (byte)Integer.parseInt(b2, 16);
        }
        return results;
    }

    public static boolean matchesMD5Pattern(String hash) {
        return MD5_PATTERN.matcher(hash).matches();
    }
}

